/**
 * Copyright hacker_ciaxk5up ( http://wonderfl.net/user/hacker_ciaxk5up )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/51AE
 */

// forked from yanbaka's 内サイクロイド（星芒形）
package
{

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	public class Hypocycloid extends Sprite
	{
		private const WIDHT:Number = stage.stageWidth;
		private const HEIGHT:Number = stage.stageHeight;
		private var isDown:Boolean = false;
		public var stars:Array = [];
		
		
		public function Hypocycloid()
		{
			this.graphics.beginFill(0x0);
			this.graphics.drawRect(0, 0, WIDHT, HEIGHT);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function mouseDownHandler(e:MouseEvent):void
		{
			isDown = true;
		}
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			isDown = false;
		}
		
		private function loop(e:Event):void
		{
			if(isDown)
			{
				var star:Star = new Star();
				stars.push(star);
				addChild(star);
			}
			
			move();
		}
		
		private function move():void
		{
			var i:int = stars.length;
			while(i--)
			{
				var star:Star = stars[i];
				if(star.end)
				{
					star.x += star.xs;
					star.y += star.ys;
					star.xs*=1.02;
					star.ys*=1.08;
					star.alpha *= 0.98;
					if(star.alpha < 0.1)
					{
						star.graphics.clear();
						removeChild(star);
						stars.splice(i, 1);
					}
				}
			}
		}
	}
}
	import flash.display.Shape;
	import flash.events.Event;
	import flash.display.IBitmapDrawable;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.BlendMode;
	import flash.filters.DropShadowFilter;
	import flash.filters.GlowFilter;
	

class Star extends Shape
{
	public var end:Boolean = false;
	public var xs:Number = Math.random()*4+1;
	public var ys:Number = Math.random()*4+1;
	private var a:int = 5;
	private var b:int = 2;
	private var t:int = 4;
	private var angle:Number = 0;
	private var r:int = Math.random()*9+1;
	private var mx:Number
	private var my:Number;
	
	public function Star()
	{
		mx = mouseX;
		my = mouseY;
		
		blendMode = BlendMode.ADD;
		
		var rc:uint = (Math.random()*0x3F+0xC0)<<16;
		var gc:uint = (Math.random()*0x80)<<8;
		var bc:uint = 0x00;
		var c:uint = rc|gc|bc;
		graphics.lineStyle(3, c);
		addEventListener(Event.ENTER_FRAME, loop);
	}
	
	private function loop(e:Event):void
	{
		if(angle < Math.PI*t)
		{
			var t:Number = ((a-b)/b)*angle;
			var xx:Number = (a-b)*Math.cos(angle)+b*Math.cos(t);
			var yy:Number = (a-b)*Math.sin(angle)-b*Math.sin(t);
			var tx:Number = xx*r+mx;
			var ty:Number = yy*r+my;
			(angle==0)? graphics.moveTo(tx, ty):graphics.lineTo(tx, ty);
			angle += 0.5;
		}
		else
		{
			graphics.endFill();
			end = true;
		}
	}
}