/**
 * Copyright takishiki ( http://wonderfl.net/user/takishiki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/510N
 */

/*
 * kaleidoscope
 * 万華鏡っぽい表現(1)
 * あくまで「万華鏡っぽい」。
 * エレガントな方法が思いつかなかったので力技です・・・
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import com.actionsnippet.qbox.*;
    import Box2D.Common.Math.b2Vec2;
    import com.actionsnippet.qbox.QuickBox2D;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.display.BlendMode;
    import flash.geom.ColorTransform;
    
    
    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)]
     public class Main extends MovieClip 
    {
        private const LEN:int = 100;
        private const NUM:int = 20;
        private const DEBUG:Boolean = false;
        
        private var _sp:Sprite;
        private var _bmp:Bitmap;
        private var _bmpd:BitmapData;
        private var _sim:QuickBox2D;
        private var _deg:Number = 0;
        
        private var _bmpd2:BitmapData;
        
        // 
        public function Main():void {
            stage.frameRate = 60;
            
            _sim = new QuickBox2D(this, { debug:DEBUG } );
            _sim.setDefault( { fillColor:0x000000, lineAlpha:0, radius:1.5 } );
            _sim.createStageWalls();
            
            var a:Number = stage.stageWidth / 4 / 30;
            _sim.addBox( { x:a, y:a * 2, width:0.5, height:a * 2, angle:0, density:0, fillColor:0x000000 } );
            _sim.addBox( { x:a * 3, y:a * 2, width:0.5, height:a * 2, angle:0, density:0, fillColor:0x000000 } );
            _sim.addBox( { x:a * 2, y:a, width:a * 2, height:0.5, angle:0, density:0, fillColor:0x000000 } );
            _sim.addBox( { x:a * 2, y:a * 3, width:a * 2, height:0.5, angle:0, density:0, fillColor:0x000000 } );
            
            _sim.gravity = new b2Vec2(0, 0);
            
            var type:int;
            var i:int;
            for (i = 0; i < NUM; i++) {
                type = randRange(0, 1);
                if (type == 0) {
                    _sim.addBox( {
                        x:stage.stageWidth / 30 / 2, y:stage.stageHeight / 30 / 2, 
                        width:randRange(1, 15) / 10, height:randRange(1, 15) / 10, 
                        fillColor:randRange(1, 0xFFFFFF), fillAlpha:randRange(5, 10) / 10, 
                        lineColor:randRange(0, 0), lineAlpha:0
                    } );
                    
                }else {
                    _sim.addCircle( { 
                        x:stage.stageWidth / 30 / 2, y:stage.stageHeight / 30 / 2, 
                        radius:randRange(1, 10) / 10,
                        fillColor:randRange(1, 0xFFFFFF), fillAlpha:randRange(5, 10) / 10, 
                        lineColor:randRange(0, 0), lineAlpha:0
                    } );
                }
            }
            
            _sim.start();
            _sim.mouseDrag();
            
            var r3:Number = Math.sqrt(3);
            
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(0x000000, 0.8);
            sp.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            sp.graphics.moveTo(stage.stageWidth / 2, stage.stageHeight / 2 - LEN * r3 / 4);
            sp.graphics.lineTo(stage.stageWidth / 2 + LEN / 2, stage.stageHeight / 2 + LEN * r3 / 4);
            sp.graphics.lineTo(stage.stageWidth / 2 - LEN / 2, stage.stageHeight / 2 + LEN * r3 / 4);
            sp.graphics.lineTo(stage.stageWidth / 2, stage.stageHeight / 2 - LEN * r3 / 4);
            sp.graphics.endFill();
            this.addChild(sp);
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            _bmpd2 = new BitmapData(LEN, Math.round(LEN * r3 / 2), false, 0x000000);
            
            _bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            _bmp = new Bitmap(_bmpd);
            _sp = new Sprite();
            _sp.addChild(_bmp);
            this.addChild(_sp);
        }
        
        // 
        private function onEnterFrame(event:Event):void {
            _deg += 1;
            _deg %= 360;
            
            var rad:Number = _deg / 180 * Math.PI;
            var s:Number = 20;
            _sim.gravity = new b2Vec2(s * Math.cos(rad), s * Math.sin(rad));
            
            makeImage();
        }
        
        // 
        private function makeImage():void {
            _sp.visible = false;
            
            var bmpd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
            bmpd.lock();
            bmpd.draw(this);
            bmpd.unlock();
            
            var r3:Number = Math.sqrt(3);
            var rect:Rectangle = new Rectangle();
            rect.x = Math.floor((stage.stageWidth - LEN) / 2);
            rect.y = Math.floor((stage.stageHeight - LEN * r3 / 2) / 2);
            rect.width = LEN;
            rect.height = Math.round(LEN * r3 / 2);
            
            _bmpd2.copyPixels(bmpd, rect, new Point(0, 0));
            
            var matrix:Matrix = new Matrix();
            
            rect = new Rectangle();
            rect.x = 0;
            rect.y = 0;
            rect.width = _bmpd2.width;
            rect.height = _bmpd2.height;
            
            _bmpd.lock();
            _bmpd.fillRect(new Rectangle(0, 0, _bmpd.width, _bmpd.height), 0x000000);
            
            var i:int;
            var rad:Number = Math.PI / 3;
            var len:int = stage.stageWidth
            for (i = 0; i < 6; i++) {
                matrix = new Matrix();
                matrix.createBox(1, 1, rad * i, stage.stageWidth / 2, stage.stageHeight / 2);
                _bmpd.draw(_bmpd2, matrix, new ColorTransform(), BlendMode.LIGHTEN);
            }
            _bmpd.unlock();
            
            _sp.visible = true;
        }
        
        // a-bの乱数生成
        private function randRange(min:Number = 0, max:Number = 1):Number {
            var randomNum:Number = Math.floor(Math.random() * (max - min + 1)) + min;
            return randomNum;
        }
        
    }
    
}
