/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/50kl
 */

// forked from fukt's forked from: forked from: Tiling
// forked from fukt's forked from: Tiling
// forked from quqjp's Tiling
package 
{
    
    /*
    * Tiling
    * 四角を順に敷き詰めていきます.
    * http://blog.quq.jp/
    * http://twitter.com/quqjp
    * 
    * 修正2009.05.20 11：16
    * はじめに四角の描画が欠けるのを対処
    * 四角の数を増やした
    * 
    *
    * ※ スクロールがBitmapData高さを超えると表示がおかしくなりますw
    */
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    [SWF(width = "465", height = "465", backgroundColor = "0xCCCCCC", frameRate = "60")]
    public class  FlashTest extends Sprite
    {
        
        private var tileConfig:Array;
        private var tilew:uint;
        private var tileh:uint;
        private var myPosition:uint = 0;
        private var myNextMax:uint;
        private var oMapLogic:MapLogic;
        private var canvasBitmapData:BitmapData;
        private var tileScale:uint = 1;
        private var canvasBitmapDataScrollYTotal:uint = 0;
        
        public function FlashTest() {
            this.stage.align = "LT"
            this.stage.quality = StageQuality.LOW;
            build();
        }
        
        public function build ():void {
            
            canvasBitmapData = new BitmapData(465, 2800, false, 0xCCCCCC);
            this.addChild(new Bitmap(canvasBitmapData));
            
            tileScale = 5;
            
            tileConfig =  [];
            for (var j:uint = 1; j < 50; j++) {
                tileConfig.push(new Tile(j, j, getRandomColor(), tileScale));
            }
                   
            myNextMax = tileConfig.length;
                   
            var maxw:uint = 0;
            var l:uint = tileConfig.length;
            for(var i:uint=0;i<l;i++){
                maxw = tileConfig[i].wcount > maxw ? tileConfig[i].wcount : maxw;
            }
            
            tilew = 92;
            tileh = 92;
            
            oMapLogic = new MapLogic(tilew, tilew, maxw);
            
            startRender();
        }
        
        private function startRender():void {
            this.addEventListener(Event.ENTER_FRAME, render);
        }
        
        private function stopRender():void {
            
        }
        
        private var renderCount:uint = 0;
        private function render(e:Event = null ):void {
            if (renderCount % 4 == 0 && renderCount > 100) {
                canvasBitmapData.scroll(0, -1);
                canvasBitmapDataScrollYTotal--;
                renderCount = 100;
            }
            renderCount++
            create();
        }
        
        private function create():void {
                    
            var confcnt:uint = Math.floor(Math.random() * ((myNextMax - 1) - 0 + 1)) + 0;
            var myTile:Tile = tileConfig[confcnt] as Tile;
            oMapLogic.addTile(myPosition, myTile);
                    
            var px:uint = myPosition % tilew * tileScale;
            var py:uint = myPosition == 0 ? 0 : (Math.ceil(myPosition/tilew)-1) * tileScale;
            py = myPosition % tilew == 0 ? myPosition / tilew * tileScale : py;
                    
            py += canvasBitmapDataScrollYTotal
                    
            var ma:Matrix = new Matrix()
            ma.translate(px, py);
            canvasBitmapData.draw(myTile.visual,ma);
                    
            var o:Object = oMapLogic.getNextEmptyPosition();
            myPosition = o.newEmptyPositon;
            myNextMax = o.newEmptyWCount;
                    
        }
    
        private function getRandomColor():Number {
           // var rr:String = 255;
            // var gg:String = (255);
            // var bb:String = (Math.floor(Math.random() * ((255 - 1) - 0 + 1)) + 0).toString(16);
            return parseInt("0x"+99 +""+ 0 +""+ 0,16
            );
        }
        
    }
    
}

import adobe.utils.CustomActions;
import flash.display.Graphics;
import flash.display.Sprite;

class Tile
{
    
    public var wcount:uint;
    public var hcount:uint;
    public var visual:TileVisual;
    
    public function Tile(sizew:uint,sizeh:uint,color:Number,scale:uint) {
        this.wcount = sizew;
        this.hcount = sizeh;
        this.visual = new TileVisual(sizew*scale, sizeh*scale, color);
    }

}

class TileVisual extends Sprite
{

    private var size_w:uint;
    private var size_h:uint;
    private var tintcolor:Number;
    
    public function TileVisual(sizew:uint,sizeh:uint,color:Number) {
        this.size_w = sizew;
        this.size_h = sizeh;
        this.tintcolor = 0xff0000;
        create();
    }
    
    private function create():void {
        var g:Graphics = this.graphics;
        
        g.beginFill(this.tintcolor); // inside
        g.drawRect(0, 0, this.size_w, this.size_h);
        g.endFill();
        
        g.beginFill(0x000000);
        g.drawRect(0, 0, this.size_w, 1);
        g.endFill();
        
        g.beginFill(0x000000);
        g.drawRect(0, 0, 1, this.size_h);
        g.endFill();
        
        g.beginFill(0x000000);
        g.drawRect(0, this.size_h - 1 , this.size_w, 1);
        g.endFill();
        
        g.beginFill(0x000000);
        g.drawRect(this.size_w - 1, 0, 1, this.size_h);
        g.endFill();
        
     //   g.lineStyle(1, 0x000000);
      //  g.moveTo(this.size_w - 1, 1);
      //  g.lineTo(1, this.size_h - 1);
        
    }

}

class MapLogic
{
    private var _map:Array;
    private var tilew:uint;
    private var tilemaxw:uint;
    private var tileh:uint;
    private var currentposition:uint = 0;
    
    public function MapLogic(sizew:uint,sizeh:uint,sizemaxw:uint) {
        _map = [];
        this.tilew = sizeh;
        this.tileh = sizeh;
        this.tilemaxw = sizemaxw;
    }
    
    public function addTile(position:uint, mytile:Tile ):void {
        currentposition = position + mytile.wcount;
        var sp:uint = position; 
        var p:uint = position;
        for(var i:uint=0;i<mytile.hcount;i++){
            for(var j:uint=0;j<mytile.wcount;j++){
                _map[p] = 1;
                p++;
            }
            p += tilew - mytile.wcount;
        }
    }
    
    public function getNextEmptyPosition():Object{
        var startposition:uint = currentposition;
        var li:Array = _map;
        var l:uint = startposition + 5000;
        var newEmptyPositon:uint = uint.MAX_VALUE
        var newEmptyWCount:uint = 0;
        var doreturn:Boolean = false;
        for(var i:uint = startposition;i<l;i++){
            if(i%tilew == 0 &&  i != startposition) doreturn = true;
            if(!li[i] && newEmptyPositon == uint.MAX_VALUE){
                newEmptyPositon = i;
                newEmptyWCount++
            }else if(newEmptyWCount >= tilemaxw){
                break;
            }else if(!li[i] && !doreturn){
                newEmptyWCount++
            }else if(newEmptyPositon != uint.MAX_VALUE){
                break;
            }
        }
        return {newEmptyPositon:newEmptyPositon,newEmptyWCount:newEmptyWCount};
    }
    
}
