/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/50Nm
 */

// image: http://www.flickr.com/photos/copilotlive/4520433270/
// original crop source: http://stackoverflow.com/questions/1843704/as3-copy-custom-shape-out-of-bitmap

// question: why is cropped image blurred?

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.PixelSnapping;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.system.Security;
    import flash.filters.DropShadowFilter;
    
  
    public class FlashTest extends Sprite {
        // ---------- crop details
        private var crop_angle:int     = 60;                   // angle
        private var crop_width:Number  = 240;                  // width
        private var crop_height:Number = 150;                  // height
        private var crop_x:Number      = 190;                  // x
        private var crop_y:Number      = 100;                  // y
                
        // ---------- image url
        private var img_url:String = "http://farm3.static.flickr.com/2768/4520433270_3bddaa755c.jpg";
        
        
       
        public function FlashTest() {
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
            
            var loader:Loader=new Loader();
            loader.load(new URLRequest(img_url));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onComplete);
        }  
        
        private function onComplete(event:Event):void
        {
            event.target.removeEventListener(Event.COMPLETE, onComplete);
            var loaded_bmp:Bitmap = new Bitmap(event.target.content.bitmapData, PixelSnapping.ALWAYS, true);    
            // loaded_bmp.smoothing = true;   // thank you  ProjectNya. I forgot to add smoothing=true :)
            addChild(loaded_bmp);
            
            var croped_bd:BitmapData = crop(loaded_bmp);            
            var result_bmp:Bitmap = new Bitmap(croped_bd, PixelSnapping.ALWAYS, true);
            result_bmp.x = 350;
            result_bmp.y = 110;
            result_bmp.rotation = crop_angle;
            result_bmp.smoothing = true;

            var dropShadow:DropShadowFilter = new DropShadowFilter( 0, 45, 0x000000, 0.8, 4, 4, 1, 3, false, false, false );
            //result_bmp.filters = [dropShadow];
            
            addChild(result_bmp);
       }
 
       private function crop(bmp:Bitmap):BitmapData
       {
            var crop_rect:Rectangle = new Rectangle(0,0,crop_width,crop_height);            //size of the segment to copy
            var crop_point:Point = new Point(crop_x,crop_y);                                //relative position of the crop from the top/left corner of the image
            var crop_angle_rad:Number = crop_angle * Math.PI / 180;                         //angle of the crop relative to image in radians (clockwise)
    
            //transformation [tx,ty] parameters representing shift after rotation
            var dA:Number = Math.atan(crop_point.y / crop_point.x) - crop_angle_rad;
            var tX:Number = crop_point.length * Math.cos(dA);
            var tY:Number = crop_point.length * Math.sin(dA);            
            var scaleMatrix:Matrix = new Matrix(Math.cos( -  crop_angle_rad),Math.sin( -  crop_angle_rad), -  Math.sin( -  crop_angle_rad),Math.cos( -  crop_angle_rad), -  tX, -  tY);

            //copy selected segment after rotation and shift to match the size ofBitmapData
            var result_bitmap:BitmapData = new BitmapData(crop_rect.width,crop_rect.height, true, 0x00000000);
            result_bitmap.draw(bmp, scaleMatrix , null, null, crop_rect, true);
           
           return  result_bitmap;
       }  
    }
}