/**
 * Copyright skyboy ( http://wonderfl.net/user/skyboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/50AB
 */

package {
	import flash.desktop.Clipboard;
    import flash.display.*;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.system.System;
    import flash.text.*;
	import flash.ui.Keyboard;
	import flash.utils.ByteArray;
	[SWF(width='465', height='465', backgroundColor='#FFFFFF', frameRate='30')]
    public class FlashTest extends Sprite {
        private var input:TextField = new TextField;
        private var output:TextField = new TextField;
        public function FlashTest() {
            var a:TextFormat = new TextFormat("monaco");
            input.defaultTextFormat = output.defaultTextFormat = a;
			output.type = input.type = TextFieldType.INPUT;
			input.addEventListener(KeyboardEvent.KEY_UP, onUp);
			output.addEventListener(KeyboardEvent.KEY_UP, onUp);
			output.height = addChild(input).height = Math.floor(465 / 2);
			input.restrict = '01 \r\n';
			graphics.lineStyle(1, 0, 1, true);
			graphics.moveTo(0, 465 / 2);
			graphics.lineTo(465, 465 / 2);
			addChild(output).y = Math.ceil(465 / 2);
			input.width = output.width = 465;
			input.selectable = output.selectable = true;
			input.multiline = output.multiline = true;
			input.useRichTextClipboard = false;
			input.wordWrap = output.wordWrap = true;
			output.text = 'Binary Translator.\nPress enter to translate to or from binary.';
			parseOutput();
		}
		private function pad(i:int):String {
			var rtn:String = (i & 255).toString(2);
			while (rtn.length < 8) rtn = '0' + rtn;
			return rtn;
		}
		private function onUp(e:KeyboardEvent):void {
			if (e.keyCode == Keyboard.ENTER) {
				if (e.target == input) parseInput();
				else parseOutput();
			}
		}
		private function parseInput():void{
			var a:String = input.text.replace(/[^01]/g, '');
			var b:Array = a.replace(/([01]{8})/g, "$1 ").split(' '), o:ByteArray = new ByteArray;
			var i:int = b.length, j:int;
			o.length = i;
			while (j < i) {
				a = b[j];
				if (a.length == 8) {
					o[j++] = parseInt(a, 2);
				} else break;
			}
			o.length = j;
			output.text = o.readUTFBytes(j);
		}
		private function parseOutput():void{
			var a:String = '';
			var o:ByteArray = new ByteArray;
			o.writeUTFBytes(output.text);
			var i:int = o.length, j:int;
			while (j < i) {
				a += pad(o[j]); ++j;
			}
			input.text = a;
		}
    }
}