/**
 * Copyright JorgeBraccini ( http://wonderfl.net/user/JorgeBraccini )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4zFR
 */

package {
    import flash.display.BlendMode;
    import flash.display.LoaderInfo;
    import flash.utils.ByteArray;
    import flash.events.IOErrorEvent;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLLoader;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.geom.Point;
    
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.display.BitmapData;
    import net.hires.debug.Stats;
    import flash.external.ExternalInterface;
    import com.greensock.TweenLite;
    import com.greensock.TimelineLite;
    import com.greensock.easing.*;
    
    public class FlashTest extends Sprite {
       
        private var _engine:BmpEngine;
        private var _children:int  = 10000;
        private var _size:Number = 1;
        
        private var _source:Bitmap;
        
        public function FlashTest() {
            if(stage)     setup();
            else          addEventListener(Event.ADDED_TO_STAGE, setup);
        }
        
        private function setup(e:Event = null):void {
            Console.init(this);
            Console.tracer = trace;
            
            load();
        }
        
        private function load():void {
            Console.log("load()");
            
            var url:URLRequest = new URLRequest("http://www.jbraccini.com/files/bang.png");
            var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, handleImageLoaded);
                loader.load(url, new LoaderContext(true));
        }

        
        private function handleImageLoaded(e:Event):void {
            Console.log("handleImageLoaded()");
            _source = e.target.content as Bitmap;
            init();
        }



        
        private function init():void {
            Console.log("init()");
            _engine = new BmpEngine(stage.stageWidth, 360);
            //_engine.addEventListener(BmpEngine.ENTER_RENDER, handleRender);
            _engine.start();
            
            addChild(_engine);
            addChild(new Stats());
            
            var child:Bitmap;
            for(var i:int = 0; i < _children; i++) {
                child = new Bitmap(new BitmapData(_source.width, _source.height, true, 0xffffffff));
                child.bitmapData = _source.bitmapData;
                child.x = Math.random() * _engine.width;
                child.y = _engine.height + (Math.random() * _engine.height);
                
                _engine.addChild(child);
            }
            
            intro();

        }
        
        private function intro():void {
            var l:int = _engine.children.length;
            var child:Bitmap;
            var tweens:Array = [];
            var h:int;
            
            Console.log("intro()");
                
            for(var i:int = 0; i < l; i++) {
                h = Math.random() * _engine.height;

                child = _engine.children[i];
                child.y = _engine.height + _size;
                tweens.push(TweenLite.to(child, .9, { y: Math.random() * _engine.height, ease: Strong.easeOut }));
            }
            
            var t:TimelineLite = new TimelineLite({onComplete: outro});
                t.appendMultiple(tweens, 0, "start", .001);
                t.play();
                
        }
        
        

        private function outro():void {
            var l:int = _engine.children.length;
            var child:Bitmap;
            var tweens:Array = [];
            
            Console.log("outro()");                

            for(var i:int = 0; i < l; i++) {
                child = _engine.children[i];
                tweens.push(TweenLite.to(child, 1, { y: -(Math.random() * _engine.height), ease: Strong.easeIn }));
            }            

            var t:TimelineLite = new TimelineLite({onComplete: intro});
                t.appendMultiple(tweens, 0, "start", .001);
                t.play();                
        }

        
        private function handleRender(e:Event):void {
            var c:Array = _engine.children;
            var t:int = c.length;
            var child:Bitmap;
            
            for(var i:int = 0; i < t; i++) {
                child = c[i];
                child.y ++;
                if(child.y > _engine.height) child.y = -_size;
            }

        }


   }

}
import flash.events.Event;

///////////////////////////////////////////////////////////////////
// MICRO FRAMEWORK ////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

import flash.display.DisplayObjectContainer;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.TimerEvent;
import flash.utils.Timer;


class BmpContainer extends Bitmap {
    
    public var children:Array;
    
    public function BmpContainer(source:BitmapData) {
        super(source);
        children = [];
    }
    
    public function addChild(child:Bitmap):void {
        children.push(child);
    }
    
    public function removeChild(child:Bitmap):void {
        children.splice(children.indexOf(child), 1);
    }
    
}



class BmpEngine extends BmpContainer {
    
    public static var ENTER_RENDER:String = "enterRender";
    
    private var _clock:Timer;
    private var _initied:Boolean = false;
    private var _source:BitmapData;
    
    public function BmpEngine(w:Number, h:Number) {
        _source = new BitmapData(w, h, false, 0);
        super(_source);
        init();
    }
    
    public function start():void {
        if(_initied) _clock.start();
    }

    public function stop():void {
       if(_initied) _clock.stop();
    }    
    
    public function forceRender():void {
        render();
    }

    
    // PRIVATE
    
    private function init():void {
        _clock = new Timer(33);
        _clock.addEventListener(TimerEvent.TIMER, handleTick);
        
        _initied = true;
    }
    
    private function render():void {
        dispatchEvent(new Event(BmpEngine.ENTER_RENDER));
        
        _source = new BitmapData(_source.width, _source.height, false, 0);
        
        var child:Bitmap;
        var t:int = children.length;
        for(var i:int = 0; i < t; i++) {
            child = children[i];
            _source.copyPixels(child.bitmapData, new Rectangle(0, 0, child.width, child.height), new Point(child.x, child.y));
            bitmapData = _source;
        }
    }

    
    private function handleTick(e:TimerEvent):void {
        render();
    }

}


/////////////////////////////////////////////////////////////////
// TRACE ////////////////////////////////////////////////////////


class Console {
    public static var tracer:Function;
    public static function init(s:DisplayObjectContainer):void {
        inittrace(s);
    }

    public static function log(s:*):void {
       if(tracer != null) tracer(s); 
    }
}

class Force {}


import flash.display.Sprite;
import com.bit101.components.TextArea;
var textarea:TextArea;
function inittrace(mainRef:DisplayObjectContainer):void {
    textarea = new TextArea();
    textarea.editable = false;
    textarea.width = mainRef.stage.stageWidth;
    textarea.height = 100;
    textarea.y = mainRef.stage.stageHeight - textarea.height;
    mainRef.addChild(textarea);
}

function doTrace(...args):void {
    var s:String = "";
    for each(var field:* in args) s += field.toString()+" ";
    s+="\n";    
    try {textarea.text = s + textarea.text;}catch (e:Error){}
}
var trace:Function = doTrace;