/**
 * Copyright k2syndrome_g ( http://wonderfl.net/user/k2syndrome_g )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4yjO
 */

package {
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.core.proto.MaterialObject3D;
    [SWF(backgroundColor = 0x111111)]
    public class FlashTest extends BasicView {
        private var _t:Number=0;
        private var _spherical:Spherical=new Spherical();
        private var _materialArray:Array=new Array();
        private var _sphere:Sphere;
        private var _cube:Cube;
        private var _materialCount:int=0;
        private var _light:PointLight3D=new PointLight3D(false,false);
        public function FlashTest() {
            // write as3 code here..
            //フィールド作成
            var field:Plane=new Plane(null,1000,1000,10,10);
            scene.addChild(field);
            field.rotationX=90;
            field.y=-200;
            _light.x=0;
            _light.y=0;
            _light.z=0;
            //シェーダマテリアル作成
            _materialArray.push(new FlatShadeMaterial(_light,0xffffff,0x0,0));
            _materialArray.push(new GouraudMaterial(_light,0xffffff,0x0,0));
            _materialArray.push(new PhongMaterial(_light,0xffffff,0x0,0));
            _materialArray.push(new CellMaterial(_light,0xffffff,0x0,10));
            //プリミティブオブジェクト作成
            _sphere=new Sphere(new ColorMaterial(0xffffff*Math.random()),100);
            scene.addChild(_sphere);
            _sphere.x=-150;
            var materialsList:MaterialsList=new MaterialsList({all:new ColorMaterial(0xffffff*Math.random())});
            _cube=new Cube(materialsList,200,200,200);
            scene.addChild(_cube);
            _cube.x=150;
            //イベントリスナ、レンダリング
            addEventListener(Event.ENTER_FRAME,_onEnterFrame);
            stage.addEventListener(MouseEvent.CLICK,_onMouseClick);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,_onKeyDown);
            startRendering();
        }
        private function _onEnterFrame(event:Event):void{
            _t+=3;
            _spherical.setSpherical3D(500,_t,45);
            camera.x=_spherical.x;
            camera.z=_spherical.z;
            camera.y=_spherical.y;
            //
        }
        private function _onMouseClick(mouseEvent:MouseEvent):void{
            var material:MaterialObject3D=_materialArray[_materialCount%4];
            _sphere.material=material;
            _cube.replaceMaterialByName(material,"all");
            _materialCount++;
        }
        private function _onKeyDown(keyboardEvent:KeyboardEvent):void{
            switch(keyboardEvent.keyCode){
                case 38:
                    _light.z+=10;
                    break;
                case 40:
                    _light.z-=10;
                    break;
                case 39:
                    _light.x+=10;
                    break;
                case 37:
                    _light.x-=10;
                    break;
                default:
                    break;
            }
        }
    }
}
//球座標系をカテシアン座標系に変換するクラス
class Spherical extends Object{
    public static const rad:Number=Math.PI/180; 
    public var x:Number=0;
    public var y:Number=0;
    public var z:Number=0;
    public function setSpherical3D(radius:Number=1,theta:Number=0,phi:Number=90):Spherical{
        setSpherical2D(radius,theta);
        phi*=rad;
        var sinp:Number=Math.sin(phi);
        x*=sinp;
        z*=sinp;
        y=radius*Math.cos(phi);
        return this;
    }
    //yをいじらない時に使う
    public function setSpherical2D(radius:Number=1,theta:Number=0):Spherical{
        theta*=rad;
        x=radius*Math.cos(theta);
        z=radius*Math.sin(theta);
        return this;
    }
}