/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4yfa
 */

// forked from Blue_fox_and_red_grape's TextMotion
package {
    import flash.text.TextFormatAlign;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import gs.TweenLite;
    import gs.easing.Circ;
    
    public class TextMotion extends Sprite
    {
        
        private var pleaseClickTheScreen:TextField;
        private var wonderfl:TextField;
        private var red:TextFormat;
        private var small:TextFormat;
        private var splitedTextArray:Array;
        private var targetX:Array;
        private var targetY:Array;
        
        public function TextMotion()
        {
            pleaseClickTheScreen = addChild( new TextField ) as TextField;
            with( pleaseClickTheScreen )
            {
                text = "Please click the screen";
                autoSize = TextFieldAutoSize.LEFT;
                selectable = false;
                x = 10;
                y = 10;
            }
            red = new TextFormat( "_sans", 60, 0xFF0000 );
            small = new TextFormat( "_typewriter", 12, 0x999999 );
            wonderfl = new TextField;
            with( wonderfl )
            {
                defaultTextFormat = new TextFormat( "_sans", 60, 0, null, null, null, null, null, TextFormatAlign.CENTER );
                autoSize = TextFieldAutoSize.CENTER;
                selectable = false;
                text = "wonderfl\nbuild Flash online";
            }
            wonderfl.x = stage.stageWidth/2 - wonderfl.width/2;
            wonderfl.y = stage.stageHeight/2 - wonderfl.height/2;
            wonderfl.setTextFormat( red, 6, 8 );
            wonderfl.setTextFormat( small, 9, wonderfl.length );
            splitedTextArray = splitTextField( wonderfl, true );
            targetX = new Array;
            targetY = new Array;
            for( var i:int=0; i<splitedTextArray.length; ++i )
            {
                addChild( splitedTextArray[ i ] );
                targetX[ i ] = splitedTextArray[ i ].x;
                targetY[ i ] = splitedTextArray[ i ].y;
            }
            animate();
            stage.addEventListener( MouseEvent.MOUSE_DOWN, animate );
        }
        
        private function splitTextField( tf:TextField, destroySpace:Boolean = false ):Array
        {
            var returnArray:Array = new Array;
            var currentTextRect:Rectangle = tf.getCharBoundaries( 0 );
            var currentChar:String;
            var currentLength:int;
            var adjustValue:Point = new Point;
            adjustValue.x = tf.x - currentTextRect.x;
            adjustValue.y = tf.y - currentTextRect.y;
            for( var i:int; i<tf.length; ++i )
            {
                currentChar = tf.text.charAt( i );
                if( currentChar == "\r" || ( destroySpace && ( currentChar == " " || currentChar == "\t" ) ) ) {
                    continue;
                }
                returnArray.push( new TextField );
                currentLength = returnArray.length - 1;
                currentTextRect = tf.getCharBoundaries( i );
                returnArray[ currentLength ].x = currentTextRect.x + adjustValue.x;
                returnArray[ currentLength ].y = currentTextRect.y + adjustValue.y;
                returnArray[ currentLength ].text = currentChar;
                returnArray[ currentLength ].type = "dynamic";
                returnArray[ currentLength ].autoSize = "left";
                returnArray[ currentLength ].multiline = false;
                returnArray[ currentLength ].mouseWheelEnabled = false;
                returnArray[ currentLength ].selectable = tf.selectable;
                returnArray[ currentLength ].antiAliasType = tf.antiAliasType;
                returnArray[ currentLength ].background = tf.background;
                returnArray[ currentLength ].backgroundColor = tf.backgroundColor;
                returnArray[ currentLength ].border = tf.border;
                returnArray[ currentLength ].borderColor = tf.borderColor;
                returnArray[ currentLength ].defaultTextFormat = tf.defaultTextFormat;
                returnArray[ currentLength ].displayAsPassword = tf.displayAsPassword;
                returnArray[ currentLength ].embedFonts = tf.embedFonts;
                returnArray[ currentLength ].gridFitType = tf.gridFitType;
                returnArray[ currentLength ].restrict = tf.restrict;
                returnArray[ currentLength ].sharpness = tf.sharpness;
                returnArray[ currentLength ].textColor = tf.textColor;
                returnArray[ currentLength ].thickness = tf.thickness;
                returnArray[ currentLength ].setTextFormat( tf.getTextFormat( i, i+1 ) );
            }
            return returnArray;
        }
        
        private function animate( e:MouseEvent = null ):void
        {
            for( var i:int=0; i<splitedTextArray.length; ++i )
            {
                splitedTextArray[ i ].x = Math.random() * stage.stageWidth;
                splitedTextArray[ i ].y = Math.random() * stage.stageHeight;
                splitedTextArray[ i ].z = Math.random() * stage.stageHeight;
                splitedTextArray[ i ].rotationX = Math.random()*360-180;
                splitedTextArray[ i ].rotationY = Math.random()*360-180;
                splitedTextArray[ i ].rotationZ = Math.random()*360-180;
                TweenLite.to( splitedTextArray[ i ], 1, { ease:Circ.easeIn, delay:0.02*i, x:targetX[ i ], y:targetY[ i ], z:0, rotationX:0, rotationY:0, rotationZ:0 } );
            }
        }
    }
}