/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4yMZ
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
    import funnel.gui.*;

    // SignalScopeの表示を見やすくするために背景色を指定
    [SWF(backgroundColor="0x808080")]
    
    public class GainerBasic_SignalScope extends Sprite {
        // Gainerオブジェクト
        private var _gainer:Gainer;

        // ain 0の変化を表示するためのSignalScopeオブジェクト
        private var _scope:SignalScope;

        public function GainerBasic_SignalScope() {
            // Gainerのインスタンスを生成
            _gainer = new Gainer();

            // SignalScopeのインスタンスを生成して配置
            _scope = new SignalScope(0, 5, 200, "ain 0");
            addChild(_scope);

            // GainerGUIのインスタンスを生成して配置
            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            _gainer.gui = gui;
            gui.setPosition(IOModuleGUI.LEFT_BOTTOM);

            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(event:Event):void {
            // 毎フレームごとにSignalScopeの表示をアップデート
            _scope.update(_gainer.analogInput(0));
        }
    }
}
