/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4yGz
 */

package
{
    import flash.events.Event;
    import flash.display.*;
    import flash.geom.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.cameras.CameraType;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.TweenEvent;
    
    public class Main extends BasicView
    {
        private var sp:Sprite;
        private var mt:Matrix = new Matrix();
        private var setAngle:Number = 0;
        private var bmd:BitmapData;
        private var tw:ITween;
        
        [SWF(width=465, height=465, backgroundColor=0,frameRate=30)]
        
        public function Main():void
        {
            super(0, 0, true, false, CameraType.FREE);
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0x00);
            bg.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            bg.graphics.endFill();
            addChild(bg);
            mt.createGradientBox(stage.stageWidth,stage.stageHeight,45,0,0);
            sp = new Sprite();
            addChild(sp);
            
            var pm:ParticleMaterial = new ParticleMaterial(0xFFAAAA, 2, 1);
            var stars:ParticleField = new ParticleField(pm, 3000, 20, 10000, 10000, 10000);
            scene.addChild(stars);
            sp.mask = viewport;
            startRendering();
            
            animate3DCamera();
            tw.addEventListener(TweenEvent.COMPLETE,compAnimate);    
            tw.play();
            
            stage.addEventListener(Event.ENTER_FRAME,onFrame);
        }
        private function draw():void
        {
            mt.createGradientBox(stage.stageWidth,stage.stageHeight,setAngle,0,0);            
            sp.graphics.clear(); 
            sp.graphics.beginGradientFill(
                GradientType.LINEAR,
                [0x660000,0xFFaaFF,0x990000,0xFFFFaa,0xFF0000],
                [1,1,1,1,1],[0,40,140,200,255],
                mt,
                SpreadMethod.PAD
            );
            sp.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            sp.graphics.endFill();
        }
        private function animate3DCamera():void
        {
            tw = BetweenAS3.bezierTo(camera,
                {
                    x : 3000 * (Math.random() - 0.5),
                    y : 3000 * (Math.random() - 0.5),
                    z : 3000 * (Math.random() - 0.5),
                    rotationX : 360 * Math.random(),
                    rotationY : 360 * Math.random()
                },null,
                6, Quart.easeInOut);
        }
        public function compAnimate(e:TweenEvent):void
        {
            tw.removeEventListener(TweenEvent.COMPLETE,compAnimate);
            animate3DCamera()
            tw.addEventListener(TweenEvent.COMPLETE,compAnimate);
            tw.play();
        }
        
        private function onFrame(e:Event):void
        {
            setAngle+=.03;
            draw();
        }
    }
}