/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4xq0
 */

// forked from users_wonderfl's forked from: テキストの座標を求める
// forked from code's テキストの座標を求める
/*
    BitmapDataの勉強　var3 テキストの座標を求める。
    
    memo
    1.テキストをビットマップに変換
    2.その領域を全捜索
    3.黒色以外の色を発見したらその座標を配列に格納
    ４．パーティクルを作るときに、格納していた座標をparticleインスタンスのプロパティに充てる
    
    追加
    ドットテキストっぽくするには、捜索する際にステップさせてやればいい。
    1pxごとではなく3pxおきに　とか
    
    参考にさせて頂いたスクリプト
    http://wonderfl.net/c/mnwo　（nitoyonさん）
    勉強になりました。ありがとうございました！
    
*/

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    public class snow extends Sprite 
    {
        //変数
        private var pos:Vector.<Point>;
        private var particles:Vector.<particle>;
        private var canvas:BitmapData;
        private var effectCanvas:BitmapData;
        private var colorTransform:ColorTransform;
        private var canvasRect:Rectangle;
        private var particle_num:Number=10000;
        private var effectMatrix:Matrix;
        
        private var stageW:Number = stage.stageWidth;
        private var stageH:Number = stage.stageHeight;

        
        //コンストラクタ
        public function snow()
        {
            //初期設定とか
            Initialization();
            
            //文字の座標を格納する。
            LookUpTextPoint();
            
            //パーティクル作成
            createParticles();
            
            //描画用のBitmapDataを作成
            createCanvas();
            
            //ループ処理追加
            addEventListener(Event.ENTER_FRAME, loopHandler);
        }
        

        
        /***********************************************************
         * 初期化関係の関数
         ***********************************************************/
        //初期化
        private function Initialization():void
        {
            //ステージの情報　もう癖でございます。
            stage.quality = StageQuality.MEDIUM;
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //変数の初期化
            pos = new Vector.<Point>;
            colorTransform = new ColorTransform(0.8, 0.85, 0.9);
            
        }
        //パーティクル生成
        private function createParticles():void
        {
            //処理を速くする？ために固定長に設定
            particles = new Vector.<particle>(particle_num);
            particles.fixed = true;
            for (var i:Number = 0; i < particle_num; i++)
            {
                particles[i] = new particle();
                //初期化処理
                particles[i].pos = new Point(Math.random() * stageW, Math.random() * stageH);
                particles[i].color = 0xffffff * Math.random();
                particles[i].toPos = pos[Math.random() * pos.length >> 0];
            }
            
        }
        
        //テキストの座標を格納
        private function LookUpTextPoint():void
        {
            //テキストに関する設定
            var myText:TextField = new TextField();
            var myTextFormat:TextFormat = new TextFormat();
            myTextFormat.size = 100;
            myText.defaultTextFormat = myTextFormat;
            myText.autoSize = "left";
            myText.textColor = 0xffffff;
            myText.text = "あき爺です";
            
            //ビットマップデータに変換
            var bmd:BitmapData = new BitmapData(myText.width, myText.height, false,0x000000);
            bmd.draw(myText);    
        
            //座標を格納
            var cnt:Number = 0;
            var w:Number = myText.width;
            var h:Number = myText.height;
            var step:Number = 5;
            //文字列の領域を全捜索 ここの効率の良い処理方法を覚えないと
            for (var i:Number = 0; i < w; i+=step) 
            {
                for (var j:Number = 0; j < h; j+=step)
                {
                    var checkColor:uint = bmd.getPixel(i, j);
                    //黒以外の色だったら、その座標を格納
                    if (checkColor != 0x000000)
                    {
                        //pushは遅いので、インデックスを指定
                        //けどcntの加算処理も入っちゃうから、後で実験しないと
                        pos[cnt] = new Point(i, j);
                        pos[cnt].offset((stageW - myText.width)>>1, (stageH - myText.height)>>1);
                        cnt++;
                    }
                }
            }
            
            //座標を格納し終わったらテキストのBitmapDataを破棄
            bmd.dispose();
            
        }
        //描画用のBitmapDataを作成
        private function createCanvas():void
        {
            //描画用のBitmapData
            canvas = new BitmapData(stageW, stageH, false, 0x000000);
            addChild(new Bitmap(canvas) as Bitmap);
            canvasRect = canvas.rect;
            
            //キラキラ用のBitmapData
            effectCanvas = new BitmapData(stageW*0.2, stageH*0.2, false);
            var bmp:Bitmap = new Bitmap(effectCanvas, PixelSnapping.NEVER, false);
            bmp.scaleX = bmp.scaleY = 5;
            //とっても大切なスムージング
            bmp.smoothing = true;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
            effectMatrix = new Matrix(0.2,0,0,0.2);
            
        }
        
        
        
        
        /********************************************************
         * ここからループ処理関係の関数
         ********************************************************/    
        private function loopHandler(e:Event):void 
        {
            //描画ロック
            canvas.lock();
            
            //モーションブラー
            canvas.colorTransform(canvasRect, colorTransform);
            
            //パーティクル処理
            for (var i:uint = 0; i < particle_num; i++)
            {
                var p:particle = particles[i];
                //とりあえずイージングで試してみる
                //後で３Ｄ座標にする
                p.pos.x += (p.toPos.x - p.pos.x) / 20;
                p.pos.y += (p.toPos.y - p.pos.y) / 20;
                
                //暫時setPixelで
                canvas.setPixel(p.pos.x, p.pos.y, 0xffffff);
    
            }
            
            //キラキラ　ほんと感謝のエフェクトです。
            effectCanvas.draw(canvas, effectMatrix);
        
            //描画ロック解除
            canvas.unlock();
                       
        }
        
    }
    
}

import flash.geom.*;
class particle
{
    public var pos:Point;
    public var color:int;
    public var toPos:Point;    
}
    
