/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4xl7
 */

package
{
    import flash.display.*;
    import flash.events.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        public var _console :Console;
        
        public function Main()
        {
            _console = new Console();
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        private function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(_console);
            
            init();
        }
    
        private function init() :void
        {
            graphics.clear();
            graphics.lineStyle(1);
            graphics.drawRect(0, 0, stage.stageWidth-1, stage.stageHeight-1); 
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Console extends Sprite
{
    protected var _consoleText :Array;
    protected var _textField :TextField;
    
    public function Console()
    {
        _consoleText = [];
        _textField = new TextField();
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    private function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        addChild(_textField);
            
        init();
    }
    
    private function init() :void
    {
        _textField.text = "";
        
        for each (var $:String in _consoleText)
        {
            (_textField.text == "") ? _textField.appendText($) : _textField.appendText("\n" + $);
        }
    }
    
    public function get lastLine() :String
    {return _consoleText[_consoleText.length-1]}
    
    public function get allLines() :Array
    {return _consoleText}

    public function set addLine($:String) :void
    {
        _consoleText.push($);
        init();
    }
}
