/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4xk9
 */

package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;

    import Box2D.Dynamics.*;
    import Box2D.Collision.Shapes.*;
 
    public class FlashTest extends MovieClip {
        public function FlashTest() {
            var sim:QuickBox2D = new QuickBox2D(this, {debug:false});
 
            var box:QuickObject = sim.addBox({x:12, y:16, width:3, height:3, density:0 , groupIndex:-1});
            var circle:QuickObject = sim.addCircle({x:5, y:3, radius:0.5, groupIndex:-1});
 
            // add another box to show that Box2D is still working
            var littleBox:QuickObject = sim.addBox({x:12, y:3, width:1, height:1});
 
            sim.createStageWalls();
 
            sim.start();
            sim.mouseDrag();
 
            var filter:QuickContactFilter = new QuickContactFilter();
            filter.addGroupIndexCallback(onGroupNeg1, -1);
 
            function onGroupNeg1(a:b2Shape, b:b2Shape):void{
                //trace("group index -1 had a collision");
                box.userData.alpha = 0.5;
                //setTimeout(function():void{ box.userData.alpha = 1 }, 200);
            }
 
            sim.w.SetContactFilter(filter);
        }
    }
}

import com.actionsnippet.qbox.*;
import Box2D.Collision.*;
import Box2D.Collision.Shapes.*;
import Box2D.Dynamics.Contacts.*;
import Box2D.Dynamics.*;
import Box2D.Common.Math.*;
import Box2D.Common.*;

class QuickContactFilter extends b2ContactFilter
{

    private var indices:Array = [];
    private var callbacks:Array = [];
    
    public function addGroupIndexCallback(func:Function, index:int):void{
        callbacks.push(func);
        indices.push(index);
    }
    
    override public function ShouldCollide(shape1:b2Shape, shape2:b2Shape):Boolean{
        var filter1:b2FilterData = shape1.GetFilterData();
        var filter2:b2FilterData = shape2.GetFilterData();
        
        // only difference between default Box2D behavior
        for (var i:int = 0; i<indices.length; i++){
            var index:int = indices[i];
            if (filter1.groupIndex == index && filter2.groupIndex == index){
                callbacks[i](shape1, shape2);
            }
        }
        // -- 
        
        if (filter1.groupIndex == filter2.groupIndex && filter1.groupIndex != 0)
        {
            return filter1.groupIndex > 0;
        }
        
        var collide:Boolean = (filter1.maskBits & filter2.categoryBits) != 0 && (filter1.categoryBits & filter2.maskBits) != 0;
        return collide;
    }
    
}
