/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4wtr
 */

// forked from Quasimondo's Mountain Cover Example
package {
    import flash.events.Event;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.*;
    
    public class Mountains extends Sprite {
        
        private var mountainMap:BitmapData;
        private var falloffMap:BitmapData;
        private var noiseMap:BitmapData;
        
        private const canvasWidth:int = 450;
        private const canvasHeight:int = 450;
        private const padding:int = 24;
        private const maxMountainHeight:int = 32;
        private const lineDistance:int = 5;
        private const verticalAdjust:int = -20;
         
        private var perlinSeed:int;   
        private const perlinOffsets:Array = [new Point(),new Point(),new Point()];
        private var _buffer:Vector.<Number>;
        
        public function Mountains() {
            init();
            stage.addEventListener(Event.ENTER_FRAME,render);
        }
        
        private function init():void
        {
             mountainMap = new BitmapData(canvasWidth,canvasHeight,false,0);
             falloffMap = new BitmapData(canvasWidth,canvasHeight,false,0);
             noiseMap = new BitmapData(canvasWidth,canvasHeight,false,0);
             
             
             var g:Graphics = graphics;
             
             g.clear();
             g.beginFill(0xffffff);
             g.drawRect(canvasWidth*0.3,0,canvasWidth*0.4,canvasHeight);
             g.endFill();
             falloffMap.draw(this);
             falloffMap.applyFilter(falloffMap,falloffMap.rect,new Point(),new BlurFilter(canvasWidth*0.1,0,2));
            
             perlinSeed = Math.random() * 0xfffffF;
             _buffer = new Vector.<Number>(canvasWidth,true);
             
             
        }

        private function render( event:Event ):void
        {
            renderMountains();
        }

        
        private function renderMountains():void
        {
            
            mountainMap.perlinNoise(64,8,4,perlinSeed,false,true,1,true,perlinOffsets);
            noiseMap.noise(Math.random()*0xffffff,0,2,1,true);
            
            mountainMap.draw(falloffMap,null,null,"multiply");
            mountainMap.draw(noiseMap,null,null,"add");
            
            var g:Graphics = graphics;
            g.clear();
            g.beginFill(0);
            g.drawRect(0,0,canvasWidth,canvasHeight);
            g.endFill();
            
            var buffer:Vector.<Number> = _buffer;
            for ( var y:int = padding + maxMountainHeight; y < canvasHeight-padding; y += lineDistance )
            {
                
                g.lineStyle();
                g.beginFill(0);
                buffer[padding] = y -(mountainMap.getPixel(padding,y) & 0xff) / 255 * maxMountainHeight + verticalAdjust;
                g.moveTo( padding,buffer[padding] );
                for ( var x:int = padding; x < canvasWidth - padding; x++ )
                {
                    buffer[x] = y - (mountainMap.getPixel(x,y) & 0xff) / 255 * maxMountainHeight + verticalAdjust;
                    g.lineTo(x,buffer[x]);
                }
                g.lineTo( x, y+2 + verticalAdjust);
                g.lineTo( padding, y+2 + verticalAdjust );
                g.lineTo( padding,buffer[padding]);
                g.endFill();
                
                g.moveTo( padding,buffer[padding]);
                g.lineStyle(1,0xffffff);
                for ( x = padding; x < canvasWidth - padding; x++ )
                {
                    g.lineTo(x,buffer[x]);
                }
            }
            
            perlinOffsets[0].x += 0.6;
            perlinOffsets[1].y += 0.25;
            
        }

    }
}