/**
 * Copyright Dorara ( http://wonderfl.net/user/Dorara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4w7n
 */

// Fire Ball
//  　あれはなんだ！？人か！？飛行機か！？ＵＦＯだー！！？
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;

	[SWF(width="465", height="465",backgroundColor=0x00000000,frameRate=30)]
	public class firefire extends Sprite
	{
		private var n_particles:int = 150; //ボールから出るパーティクルの数
		private var n_yakekoge:int = 300; //ボールの軌跡を保持して、動くためのパーティクルの数(?)
		
		private var parts:Array; //ボールからでるパーティクル
		private var yakekoge:Array; //ボールの軌跡のパーティクル
		private var ball:Sprite; //ボール

		//表示用(Field全体)
		private var sp:Sprite;				
		private var bmpData:BitmapData;
		private var bmp:Bitmap;
		
		
		public function firefire()
		{
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			this.stage.align = StageAlign.TOP_LEFT;
			
			sp = new Sprite();
			parts = new Array(n_particles);
			yakekoge = new Array(n_yakekoge);
			
			//各パーティクルの初期化
			for(var i:int = 0; i<n_particles; i++){
				var tmp:particle = new particle();
				parts[i] = tmp;
				tmp.x = mouseX;
				tmp.y = mouseY;
				tmp.vx = 2*Math.random()-1.0;
				tmp.vy = 2*Math.random()-1.0;
				tmp.life = 30*Math.random()+10;
				tmp.alpha = 0xFF;
			}
			for(i = 0; i<n_yakekoge; i++){
				tmp = new particle();
				yakekoge[i] = tmp;
				tmp.x = mouseX;
				tmp.y = mouseY;
				tmp.vx = 0.6*Math.random()-0.3;
				tmp.vy = 0.6*Math.random()-0.3;
				tmp.life = 50*Math.random()+50;
			}
			//ボールの初期化
			ball = new Sprite();
			ball.graphics.beginFill(0xFFFFFF);
			ball.graphics.drawCircle(0, 0, 2);
			ball.graphics.endFill();
			
			bmpData = new BitmapData(this.stage.stageWidth, this.stage.stageHeight, true);
			bmp = new Bitmap(bmpData);
			sp.addChild(bmp);
			
			//ボールは、ぼかせて発行体のようにする
			ball.filters = [new GlowFilter(0xff0000, 1, 16,16, 4, 2),new GlowFilter(0xFA3C0F, 1, 4,4, 4, 2), new BlurFilter(1, 1, 1)];
			
			bmpData.fillRect(bmpData.rect, 0x00000000);
			this.addChild(sp);		
			this.addChild(ball);
			this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		public function onEnterFrame(e:Event):void
		{
			bmpData.fillRect(bmpData.rect, 0x00000000); //きれいにする
			
			//焼け焦げの描写
			for(var j:int = 0; j<n_yakekoge; j++){
				if(yakekoge[j].life < 0){
					yakekoge[j].x = mouseX;
					yakekoge[j].y = mouseY;
					yakekoge[i].vx = 0.6*Math.random()-0.3;
					yakekoge[i].vy = 0.6*Math.random()-0.3;
					yakekoge[j].life = 50*Math.random()+50;
					yakekoge[j].alpha = 0xFF;
				}
				bmpData.setPixel32(yakekoge[j].x + 4*Math.random()-2, yakekoge[j].y + 4*Math.random()-2, 0x00FA3C0F | yakekoge[j].alpha<<24);
				bmpData.setPixel32(yakekoge[j].x + 4*Math.random()-2, yakekoge[j].y + 4*Math.random()-2, 0x00FA3C0F | yakekoge[j].alpha<<24);
				yakekoge[j].x += yakekoge[j].vx;
				yakekoge[j].y += yakekoge[j].vy;
				yakekoge[j].life--;
				yakekoge[j].alpha -= 0x04;
				if(yakekoge[j].alpha < 0x00) yakekoge[j].alpha = 0x00; 
			}
			
			//パーティクルの描写
			for(var i:int = 0; i<n_particles; i++){
				if(parts[i].life < 0){
					parts[i].x = mouseX;
					parts[i].y = mouseY;
					parts[i].vx = 2*Math.random()-1.0;
					parts[i].vy = 2*Math.random()-1.0;
					parts[i].life = 30*Math.random()+10;
					parts[i].alpha = 0xFF;
				}
				bmpData.setPixel32(parts[i].x, parts[i].y, 0x00FA3C0F | parts[i].alpha<<24);
				parts[i].x += parts[i].vx;
				parts[i].y += parts[i].vy;
				parts[i].life--;
				parts[i].alpha -= 0x06;
				if(parts[i].alpha < 0x00) parts[i].alpha = 0x00;
			}
			
			//fireballの描写
			ball.x = mouseX;
			ball.y = mouseY;
		}
	}
}
	import flash.display.Shape;
	import flash.display.Sprite;
	

class particle{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var alpha:int;
	public var life:int; //パーティクルの寿命
}