/**
 * Copyright dimitris.1972g ( http://wonderfl.net/user/dimitris.1972g )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4w4x
 */

// forked from digibot's flash on 2009-8-10
package 
{
	import gs.easing.Elastic;
	import gs.TweenLite;
	import flash.display.Sprite;
        import flash.text.TextField;
        import flash.events.*;
        import com.bit101.components.*;
        import flash.display.Shape;
        import flash.display.DisplayObject;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	/**
	 * ...
	 * @author Digibot
	 */
	public class Main extends Sprite 
	{
	    [Embed(systemFont="sansserif", fontName="sysfont", mimeType="application/x-font")]
	    private var Font:Class;
		
	    private var num:int = 5;
            private var word:String = "Hello World";
            private var traceTxt:Text;
            private var inputText:InputText;
            private var container:Sprite;
        
            public function Main():void
            {
                // write as3 code here..
                if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
            }
        
            private function init(e:Event = null):void
            {   
	    	drawControls();   
	    	container = new Sprite;
	    	addChild(container);
            }
        
            private function onActionClick(e:MouseEvent):void
            {
                var lastTxtWidth:Number = 0;
                word = inputText.text;
                for(var i:int = 0; i < word.length; i++)
                {
		    var char:Sprite = new Sprite;
		    char.name = "char_" + i;
		    container.addChild(char);
		    var textField:TextField = createTextField(word.charAt(i));
		    textField.x = 100 + lastTxtWidth;
		    textField.y = 100;
		    char.addChild(textField);

                    lastTxtWidth += textField.textWidth;
            }
         }
         
        private function createTextField(text:String):TextField
        {
	    var textField:TextField  = new TextField();
	    textField.embedFonts = true;
	    var textFormat:TextFormat = new TextFormat;
	    textFormat.font = "sysfont";
	    textFormat.size = 20;
	    textFormat.color = 0x000000;
			
            textField.defaultTextFormat = textFormat;
	    textField.text = text;  
			
	    return textField;
        }
        
        private function drawControls():void
        {
	    var form:Sprite = new Sprite;
	    addChild(form);
	    form.y = stage.stageHeight - 150;
			
            var bg:Shape = new Shape;
            bg.graphics.beginFill(0XD6D6D6);
            bg.graphics.drawRect(0,0,stage.stageWidth, 150);
            bg.graphics.endFill();
            form.addChild(bg);
            
            var actionBtn:PushButton = new PushButton(form, 130, 20, "Start");
            actionBtn.addEventListener(MouseEvent.CLICK, onActionClick);
	    
            
	    var animateBtn:PushButton = new PushButton(form, 130, 50, "Animate");
            animateBtn.addEventListener(MouseEvent.CLICK, onAnimateClick);
	    			
            var resetBtn:PushButton = new PushButton(form, 130, 80, "Reset");
            resetBtn.addEventListener(MouseEvent.CLICK, onResetClick);
			
            traceTxt = new Text(form, 250, 20, "trace output" + "\n");
            
	    inputText = new InputText(form, 20, 20, "Hello World");
			
        }
		
	private function onAnimateClick(e:MouseEvent):void 
	{
	    var i:int = container.numChildren;
	    while ( i -- )
	    {
	        var char:DisplayObject = container.getChildAt( i );
	        TweenLite.to(char, 1, { y:"30", alpha:1, delay:.1*i, ease:Elastic.easeOut } );
	    }
	}
		
	private function onResetClick(e:MouseEvent):void
	{
	    output("removing "+ container.numChildren +" textFields" + "\n");
	    var i:int = container.numChildren;
	    while( i -- ) container.removeChildAt( i );
	}

	private function output(text:String):void
	{
	    traceTxt.text += text + "\n";
	}
        
    }
}