/**
 * Copyright nbhd ( http://wonderfl.net/user/nbhd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4vnu
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.events.Event;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#333333")]
	public class BoondockRadioBackGround extends Sprite
	{
		private var _mask:Sprite;
		private var _illusion:IllusionBall;
		private var _dotContainer:Bitmap;
		private var _dotData:BitmapData;
		private var _dotSource:BitmapData;
		
		public function BoondockRadioBackGround()
		{
			if (stage) _init();
			else addEventListener(Event.ADDED_TO_STAGE, _init);
		}

		private  function _init():void
		{
			removeEventListener(Event.ADDED_TO_STAGE, _init);
			var dummy:Sprite = new Sprite();
			dummy.graphics.beginFill(0x0);
			dummy.graphics.drawCircle(10, 10, 10);
			
			_dotSource = new BitmapData(20, 20, true, 0xffffff);
			_dotSource.draw(dummy);
			
			_dotData = new BitmapData(465, 465, true, 0xffffff);
			var p:Point = new Point();
			var n:int = 100;
			var r:Number = 10;
			var margin:Number = 0;
			for(var v:int = 0; v < n; v++) {
				for(var k:int = 0; k < n; k++) {
					if(v == 0){
						if(k == 0){
							_dotData.copyPixels(_dotSource, _dotSource.rect, p);
						}else {
							p.x = (p.x + r * 2 + margin) * k;
							_dotData.copyPixels(_dotSource, _dotSource.rect, p);
							p.x = 0;
						}
					}else {
						if(k == 0) {
							p.y = (p.y + r * 2 + margin) * v;
							_dotData.copyPixels(_dotSource, _dotSource.rect, p);
							p.y = 0;
						}else{
							p.x = (p.x + r * 2 + margin) * k;
							p.y = (p.y + r * 2 + margin) * v;
							_dotData.copyPixels(_dotSource, _dotSource.rect, p);
							p.x = 0;
							p.y = 0;
						}
					}
				}
			}
			
			_dotContainer = new Bitmap(_dotData);
			addChild(_dotContainer);
			
			_mask = new Sprite();
			
			_illusion = new IllusionBall();
			addChild(_illusion);
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.PixelSnapping;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.geom.Rectangle;

class IllusionBall extends Sprite
{
	
	private var _bmpData:BitmapData;
	private var _bmp:Bitmap;
	private var _sp:Sprite;
	private var _defaultColor:int = 0xffffff;
	private var _colorTransForm:ColorTransform = new ColorTransform(1, 0, 1, 1, 0, 255, 255, -10);
	
	private var _setBmpData:BitmapData;
	private var _point:Point = new Point();
	
	private var _offset2:Number = Math.random();
	private var _offset3:Number = Math.random();
	
	public function IllusionBall():void
	{
		if (stage) _init();
		else addEventListener(Event.ADDED_TO_STAGE, _init);
	}
	
	private function _onResize(event:Event):void 
	{
		if(_setBmpData) {
			_setBmpData.dispose();
			_setBmpData = null;
		}
		if(_bmpData) {
			_bmpData.dispose();
			_bmpData = null;
		}
		if(_bmp) {
			if(contains(_bmp)) removeChild(_bmp);
			_bmp = null;
		}
		if(_sp) {
			if(contains(_sp)) removeChild(_sp);
			_sp = null;
		}
		_init();
	}

	private function _init(e:Event = null):void
	{
		removeEventListener(Event.ADDED_TO_STAGE, _init);
		
		_bmpData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xffffff);
		_bmp = new Bitmap(_bmpData, PixelSnapping.AUTO, true);
		addChild(_bmp);
		
		_sp = new Sprite();
		_sp.graphics.beginFill(_defaultColor);
		_sp.graphics.drawCircle(100, 100, 50);
		_sp.filters = [new BlurFilter(25, 25), new GlowFilter(0x00ffff, 0.3, 100, 100, 2), new BlurFilter(25, 25)];

		_setBmpData = new BitmapData(200, 200, true,0xffffff);
		_setBmpData.draw(_sp);
		
		_bmp.blendMode = "add";
		
		addEventListener(Event.ENTER_FRAME, _loop);
		stage.addEventListener(Event.RESIZE, _onResize);
		
	}
	
	private function _loop(e:Event):void 
	{
		if(!_sp) return;
		
		_colorTransForm.greenOffset -= _offset2;
		_colorTransForm.blueOffset += _offset3;
		if(_colorTransForm.greenOffset < -255 || _colorTransForm.greenOffset > 255) _offset2 = -_offset2;
		if(_colorTransForm.blueOffset < -255 || _colorTransForm.blueOffset > 255) _offset3 = -_offset3;
		
		_point.x += (mouseX - 100 - _point.x) * 0.05;
		_point.y += (mouseY - 100 - _point.y) * 0.05;
		
		_bmpData.lock();
		_bmpData.colorTransform(_bmpData.rect, _colorTransForm);
		
		_bmpData.copyPixels(_setBmpData, new Rectangle(0, 0, 200, 200), _point, null, null, true);
		_bmpData.unlock();
		
	}
}