/**
 * Copyright hacker_odhdknyf ( http://wonderfl.net/user/hacker_odhdknyf )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4vTj
 */

package
{    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    // Import Papervision3D
    import org.papervision3d.cameras.*;
    import org.papervision3d.scenes.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.special.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.shaders.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.render.*;
    import org.papervision3d.view.*;
    import org.papervision3d.events.*;
    import org.papervision3d.core.utils.*;
    import org.papervision3d.core.utils.virtualmouse.VirtualMouse;
    
    public class World extends BasicView
    {
        private var ball     :Sphere;
        private var vMouse   :VirtualMouse;
        private var surface  :Sprite;
        public var texture   :DisplayObject;
        public var color     :uint = 0x000000;
        public var tickness  :Number = 3;
        public var speedPitch:Number = 0.25;
        public var speedYaw  :Number = 0.25;
        
        /**
         * Constructor
         */
        public function World()
        {
            super(400, 400, false, true, CameraType.TARGET);
            
            vMouse = viewport.interactiveSceneManager.virtualMouse;
            Mouse3D.enabled = true;
        }
        
        /**
         * Init 3D & Cube
         */
        public function initObj(bmpData:BitmapData):void
        {
            var mc:MovieClip = new MovieClip();
            mc.base = mc.addChild(new Bitmap(bmpData));
            mc.surface = mc.addChild(new Sprite());
            
            var material:MovieMaterial = new MovieMaterial(mc, false, true, false, new Rectangle(0, 0, 1000, 500));
            material.smooth = false;
            material.interactive = true;
            material.allowAutoResize = false;
            
            //make an instance of the movieclip in the material
            surface = material.movie["surface"];
            texture = material.movie;
            
            //Create ball to draw on
            ball = new Sphere( material, 400, 12, 12 );
            scene.addChild(ball);
            
            startRendering();
        }
        
        /**
         * destroy
         */
        public function destroyObj():void
        {
            scene.removeChild(ball);
        }
        
        /**
         * EnterFrame Handler
         */
        override protected function onRenderTick(e:Event = null):void
        {
            //Continue drawing when the mouse is down
            if (InteractiveSceneManager.MOUSE_IS_DOWN)
            {
                surface.graphics.beginFill(color);
                surface.graphics.drawCircle(vMouse.x, vMouse.y, tickness)
                surface.graphics.endFill();
            }
            
            ball.yaw(speedYaw);
            ball.pitch(speedPitch);
            super.onRenderTick(e);
        }
    }
}