/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4uvK
 */

// forked from siouxcitizen's forked from: [Papervision3D]BitmapMaterialの練習
//Bitmapデータを読み込んで複数3DPlaneオブジェクトに貼り付ける練習
//前回無残に失敗に終わった後、やっと今回複数のPlaneオブジェクトにBitmap貼り付けられました。。。
//ちなみに前々回、前回ソースのRelated Imagesは使いまわせるようなのでURL指定して再利用してます
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.display.Bitmap;
    import flash.display.BitmapData; 
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    public class FlashTest extends BasicView {
        private var bmp:Bitmap;
        private var bmd:BitmapData;
        private var loaderForWizard:Loader; 
        private var loaderForSla:Loader;
        private var loaderForZaku:Loader;
        public function FlashTest() {
            initWizardPlane();
            initSlaPlane();
            initZakuPlane();
            initCamera();
        }
        
        public function initWizardPlane():void {
            var url:String = "http://assets.wonderfl.net/images/related_images/1/19/19c0/19c0967e02f10579880511d29d725a4a9f983f1a"
            var urlReq:URLRequest = new URLRequest(url);
            loaderForWizard = new Loader();
            loaderForWizard.load(urlReq, new LoaderContext(true)); 
            loaderForWizard.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteForWizard);
        }

        public function initSlaPlane():void {
            var url:String = "http://assets.wonderfl.net/images/related_images/e/e1/e12b/e12b4d301954b19d91c96df4bbf2eaf5fc82f726"
            var urlReq:URLRequest = new URLRequest(url);
            loaderForSla = new Loader();
            loaderForSla.load(urlReq, new LoaderContext(true)); 
            loaderForSla.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteForSla);
        }

        public function initZakuPlane():void {
            var url:String = "http://assets.wonderfl.net/images/related_images/7/7b/7be2/7be290bce731b60e8bceffb7f1bee308b342ad28"
            var urlReq:URLRequest = new URLRequest(url);
            loaderForZaku = new Loader();
            loaderForZaku.load(urlReq, new LoaderContext(true)); 
            loaderForZaku.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteForZaku);
        }

        public function initCamera():void {
            //カメラ設定
            camera.y = 800;
            camera.z = -2800;
            camera.zoom = 80;
            //レンダリング開始
            startRendering();
            //loop処理
            addEventListener(Event.ENTER_FRAME, loop);
        }
     
        private function loop(e:Event):void{
        }

        private function onCompleteForWizard(e:Event):void { 
            bmd = new BitmapData(loaderForWizard.width, loaderForWizard.height, true, 0x000000);
            bmd.draw(loaderForWizard);
            
            var material:BitmapMaterial = new BitmapMaterial(bmd, true);
            //平面を作る。引数は(material, width, height, segmentsW, segmentsH)

            var leftPlane:Plane = new Plane(material, 500, 500, 1, 1);
            leftPlane.rotationX = 90;
            leftPlane.x = -500;
            //sceneに追加
            scene.addChild(leftPlane);
            var middlePlane:Plane = new Plane(material, 500, 500, 1, 1);
            middlePlane.rotationX = 90;
            middlePlane.x = 0;
            //sceneに追加
            scene.addChild(middlePlane);
            var rightPlane:Plane = new Plane(material, 500, 500, 1, 1);
            rightPlane.rotationX = 90;
            rightPlane.x = 500;
            //sceneに追加
            scene.addChild(rightPlane);
        }

        private function onCompleteForSla(e:Event):void{
            bmd = new BitmapData(loaderForSla.width, loaderForSla.height, true, 0x000000);
            bmd.draw(loaderForSla);
            
            var material:BitmapMaterial = new BitmapMaterial(bmd, true);
            //平面を作る。引数は(material, width, height, segmentsW, segmentsH)

            var leftPlane:Plane = new Plane(material, 500, 500, 1, 1);
            leftPlane.rotationX = 90;
            leftPlane.x = -500;
            leftPlane.z = -500;
            //sceneに追加
            scene.addChild(leftPlane);
            var middlePlane:Plane = new Plane(material, 500, 500, 1, 1);
            middlePlane.rotationX = 90;
            middlePlane.x = 0;
            middlePlane.z = -500;
            //sceneに追加
            scene.addChild(middlePlane);
            var rightPlane:Plane = new Plane(material, 500, 500, 1, 1);
            rightPlane.rotationX = 90;
            rightPlane.x = 500;
            rightPlane.z = -500;
            //sceneに追加
            scene.addChild(rightPlane);
        }

        private function onCompleteForZaku(e:Event):void{
            bmd = new BitmapData(loaderForZaku.width, loaderForZaku.height, true, 0x000000);
            bmd.draw(loaderForZaku);
            
            var material:BitmapMaterial = new BitmapMaterial(bmd, true);
            //平面を作る。引数は(material, width, height, segmentsW, segmentsH)

            var leftPlane:Plane = new Plane(material, 500, 500, 1, 1);
            leftPlane.rotationX = 90;
            leftPlane.x = -500;
            leftPlane.z = -1000;
            //sceneに追加
            scene.addChild(leftPlane);
            var middlePlane:Plane = new Plane(material, 500, 500, 1, 1);
            middlePlane.rotationX = 90;
            middlePlane.x = 0;
            middlePlane.z = -1000;
            //sceneに追加
            scene.addChild(middlePlane);
            var rightPlane:Plane = new Plane(material, 500, 500, 1, 1);
            rightPlane.rotationX = 90;
            rightPlane.x = 500;
            rightPlane.z = -1000;
            //sceneに追加
            scene.addChild(rightPlane);
        }
    }
}