/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4tio
 */

/**
　　砂っぽいパーティクル
　　左マウスダウンで、パーティクル生成
　　シフト+左マウスダウンで、壁生成
*/
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;

	[SWF(width = "480", height = "480", backgroundColor = "0x000000", fps = "60")] 
	public class Practice38 extends Sprite {
		private var par:Array;
		private var bitmap:BitmapData;
		private var blur:BlurFilter;
		private var colors:Array = [0xffffffff,0xffffcdff,0xffbebebe,0xffc7c7c7,0xffaaaaaa];
		private var box:Box;
		private var wall:Wall;
		private var isDown:Boolean = false;
		private var spring:Vector.<Point>;
		private var counter:Vector.<int>;
		
		public function Practice38() {
			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			var img:Bitmap = new Bitmap(bitmap);
			addChild(img);
			blur = new BlurFilter(4, 4, 3);
			box = new Box(bitmap);
			Particle.bitmap = bitmap;
			par = new Array();
			addEventListener(Event.ENTER_FRAME, update);
			wall = new Wall(bitmap);
			box.wall = wall;
			addChild(wall);
			spring = new Vector.<Point>();
			counter = new Vector.<int>();
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, wall.mouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, wall.mouseUp);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, wall.mouseMove);
			Wonderfl.capture_delay(30);
		}
		
		private function mouseDown(e:MouseEvent):void {
			if (!e.shiftKey) {
				var pp:Point = new Point(e.stageX, e.stageY);
				spring.push(pp);
				counter.push(0);
				isDown = true;
			}
		}
		
		public function mouseUp(e:MouseEvent):void {
			isDown = false;
		}
		
		public function mouseMove(e:MouseEvent):void {
			if(isDown){
				var pp:Point = new Point(e.stageX, e.stageY);
				spring.push(pp);
				counter.push(0);
			}
		}
		
		private function closePoint(p:Point):Boolean {
			for (var i:int = 0; i < spring.length; i++) {
				var pp:Point = spring.shift();
				var cx:int = p.x - pp.x;
				var cy:int = p.y - pp.y;
				if (cx * cx + cy * cy < 100) {
					return false;
				}else {
					spring.push(pp);
				}
			}
			return true;
		}
		
		private function update(e:Event):void {
			for (var j:int = 0; j < spring.length; j++ ) {
				var sp:Point = spring.shift();
				var ct:int = counter.shift();
				var xx:Number = sp.x + 20 * Math.random() - 10;
				var yy:Number = sp.y + 20 * Math.random() - 10;
				var px:Particle = new Particle(xx, yy, colors[par.length % colors.length]);
				par.push(px);
				if (ct < 60) {
					spring.push(sp);
					counter.push(ct + 1);
				}
			}
			for each(var p:Particle in par) box.checkParticle(p);
			box.clear();
			bitmap.applyFilter(bitmap,bitmap.rect,new Point(0,0),blur);
			bitmap.lock();
			for each(p in par) {
				p.update();
				box.setParticle(p);
			}
			bitmap.unlock();
		}
	}
}
import flash.display.BitmapData;
import flash.display.MovieClip;
import flash.events.MouseEvent;
import flash.geom.Point;
class Wall extends MovieClip {
	private var wall:Vector.<int>;
	private var line:Vector.<Vector.<Point>>;
	private var tmp:BitmapData;
	private var imageWidth:int;
	private var imageHeight:int;
	private var ww:int = 80;
	private var hh:int = 120;
	private var cur:Vector.<Point>;
	
	public function Wall(b:BitmapData):void {
		imageWidth = b.width;
		imageHeight = b.height;
		wall = new Vector.<int>();
		line = new Vector.<Vector.<Point>>();
		var id:int = 0;
		for (var x:int = 0; x < b.width; x++) for (var y:int = 0; y < b.height; y++) wall[id++] = 0;
		drawWall();
	}
	
	public function mouseDown(e:MouseEvent):void {
		if (e.shiftKey) {
			cur = new Vector.<Point>();
			line.push(cur);
		}
	}
	
	public function mouseUp(e:MouseEvent):void {
		if (cur != null) {
			cur = null;
			drawWall();
		}
	}
	
	public function mouseMove(e:MouseEvent):void {
		if (cur != null) {
			cur.push(new Point(e.stageX, e.stageY));
			drawWall();
		}
	}
	
	public function drawWall():void {
		graphics.clear();
		graphics.lineStyle(2, 0x00ffff);
		for (var i:int = 0; i < line.length; i++) {
			for (var j:int = 0; j < line[i].length; j++) {
				if (j == 0) {
					graphics.moveTo(line[i][j].x, line[i][j].y);
				}else {
					graphics.lineTo(line[i][j].x, line[i][j].y);
				}
			}
		}
		tmp = new BitmapData(imageWidth, imageHeight, false, 0x000000);
		createBounds();
	}
	
	public function createBounds():void {
		tmp.fillRect(tmp.rect, 0x000000);
		tmp.draw(this);
		var id:int = 0;
		for (var i:int = 0; i < tmp.width; i++) {
			for (var j:int = 0; j < tmp.height; j++) {
				if (tmp.getPixel(i, j) == 0) {
					wall[id++] = 0;
				}else {
					wall[id++] = 1;
				}
			}
		}
	}
	
	public function init(b:Vector.<int>):void {
		for (var i:int = 0; i < b.length; i++) b[i] = wall[i];
	}
}

class Box {
	public var wall:Wall;
	private var box:Vector.<int>;
	private var bitmap:BitmapData;
	private var width:int;
	private var height:int;
	
	public function Box(b:BitmapData) {
		bitmap = b;
		width = bitmap.width;
		height = b.height;
		box = new Vector.<int>();
		var id:int = 0;
		for (var x:int = 0; x < width; x++)	for (var y:int = 0; y < height; y++) box[id++] = 0;
	}

	public function clear():void {
		wall.init(box);
	}
	
	public function setParticle(p:Particle):void {
		box[getId(p.x,p.y)] = 1;
	}

	private function getId(x:int, y:int):int {
		return Math.min(Math.max(0, x * height + y), box.length - 1);
	}
	
	public function checkParticle(p:Particle):void {
		if (box[getId(p.x,p.y+1)] == 1) {
			if (box[getId(p.x - 1, p.y + 1)] == 1) {
				if (box[getId(p.x + 1, p.y + 1)] == 1) {
					p.movable = false;	p.vx = 0;	p.vy = 0;
				}else {
					if(p.x<width-1&&box[getId(p.x + 1, p.y)] == 0)p.vx += 1;
				}
			}else if (box[getId(p.x +1, p.y + 1)] == 1) {
				if(p.x>0&&box[getId(p.x -1, p.y)] == 0)p.vx -= 1;
			}else {
				if (p.x > 0 && box[getId(p.x -1, p.y)] == 0) {
					if (p.x < width - 1 && box[getId(p.x + 1, p.y)] == 0) {
						if (Math.random() <= 0.5) {p.vx += 1;}else {p.vx -= 1;}
					}else {
						p.vx += 1;
					}
				}else {
					if (p.x < width - 1 && box[getId(p.x + 1, p.y)] == 0) {
						p.vx -= 1;
					}else {
						p.movable = false;	p.vx = 0;	p.vy = 0;
					}
				}
			}
		}else {
			p.movable = true;
			p.vx = 0;
			for (var v:int = 1; v < p.vy; v++) {
				if (box[getId(p.x , p.y + v)] == 1) {
					p.vy = v - 1;
					break;
				}
			}
		}
	}
}

class Particle {
	public static var bitmap:BitmapData;
	public static const G:Number = 0.098*2;
	public const K:Number = 0.01;
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var color:uint;
	public var movable:Boolean = true;
	
	public function Particle(_x:int,_y:int,_c:uint):void {
		x = _x;
		y = _y;
		color = _c;
		vx = 0;
		vy = 0;
	}
	
	public function update():void {
		x += vx;
		y += vy;
		bitmap.setPixel(x, y, color);
		if (movable) {
			var a:Number = G - vy * K;
			vy += a;
			if (vx > 0) {
				vx -= 1;
			}else if (vx < 0) {
				vx += 1;
			}
		}
		if (y > 480) y = 480;
	}
}