/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4tZT
 */

package
{
    import com.bit101.components.TextArea;
    import com.flashdynamix.utils.SWFProfiler;
    import flash.display.Sprite;
    import flash.events.ErrorEvent;
    import flash.events.Event;
    
    /**
     * MindSet Tester
     * @author Yukiya Okuda<alumican.net>
     */
    [SWF(backgroundColor=0xffffff, frameRate=60)]
    public class Main extends Sprite
    {
        //MindSet
        private var _mindSet:MindSet;
        
        //Interface
        private var _socketLog:TextArea;
        private var _signalLog:TextArea;
        private var _rawEegLog:TextArea;
        private var _eyeBlinkLog:TextArea;
        
        //Constructor
        public function Main():void
        {
            Wonderfl.disable_capture();
            
            _buildInterface();
            
            _mindSet = new MindSet();
            _mindSet.addEventListener(MindSet.SOCKET_CONNECT, _mindSetSocketConnectHandler);
            _mindSet.addEventListener(MindSet.SOCKET_ERROR, _mindSetSocketErrorHandler);
            _mindSet.addEventListener(MindSet.SOCKET_CLOSE, _mindSetSocketCloseHandler);
            _mindSet.addEventListener(MindSet.DATA_SIGNAL, _mindSetDataSignalHandler);
            _mindSet.addEventListener(MindSet.DATA_EEG_RAW, _mindSetDataEegRawHandler);
            _mindSet.addEventListener(MindSet.DATA_EYE_BLINK, _mindSetDataEyeBlinkHandler);
            _mindSet.connect();
            
            //SWFProfiler.init(stage, this);
        }
        
        private function _buildInterface():void
        {
            _socketLog = new TextArea(this);
            _socketLog.x      = 10;
            _socketLog.y      = 10;
            _socketLog.width  = 220;
            _socketLog.height = 220;
            
            _signalLog = new TextArea(this);
            _signalLog.x      = 10;
            _signalLog.y      = 240;
            _signalLog.width  = 220;
            _signalLog.height = 220;
            
            _rawEegLog = new TextArea(this);
            _rawEegLog.x      = 240;
            _rawEegLog.y      = 10;
            _rawEegLog.width  = 220;
            _rawEegLog.height = 220;
            
            _eyeBlinkLog = new TextArea(this);
            _eyeBlinkLog.x      = 240;
            _eyeBlinkLog.y      = 240;
            _eyeBlinkLog.width  = 220;
            _eyeBlinkLog.height = 220;
        }
        
        //MindSet Handler
        private function _mindSetSocketConnectHandler(e:Event):void
        {
            _log("Socket Connect", _socketLog);
        }
        
        private function _mindSetSocketErrorHandler(e:ErrorEvent):void
        {
            _log("Socket Error : type = " + e.type + ", text = " + e.text, _socketLog);
        }
        
        private function _mindSetSocketCloseHandler(e:Event):void 
        {
            _log("Socket Close", _socketLog);
        }
        
        private function _mindSetDataSignalHandler(e:Event):void 
        {
            _log("----------SIGNAL----------\n"
                + "Signal Level : " + _mindSet.signalLevel + "\n\n"
                + "Attention    : " + _mindSet.attention + "\n"
                + "Meditation   : " + _mindSet.meditation + "\n\n"
                + "Alpha (Low)  : " + _mindSet.lowAlpha + "\n"
                + "Alpha (High) : " + _mindSet.highAlpha + "\n"
                + "Beta (Low)   : " + _mindSet.lowBeta + "\n"
                + "Beta (High)  : " + _mindSet.highBeta + "\n"
                + "Gamma (Low)  : " + _mindSet.lowGamma + "\n"
                + "Gamma (High) : " + _mindSet.highGamma + "\n"
                + "Delta        : " + _mindSet.delta + "\n"
                + "Theta        : " + _mindSet.theta
            , _signalLog);
        }
        
        private function _mindSetDataEegRawHandler(e:Event):void 
        {
            _log("----------RAW EEG----------\n"
                + "Raw Eeg : " + _mindSet.rawEeg
            , _rawEegLog);
        }
        
        private function _mindSetDataEyeBlinkHandler(e:Event):void 
        {
            _log("----------EYE BLINK----------\n"
                + "Blink Strength : " + _mindSet.blinkStrength
            , _eyeBlinkLog);
        }
        
        private function _log(m:*, target:TextArea = null):void
        {
            if (target)
            {
                target.text = String(m);
            }
            else
            {
                trace(String(m));
            }
        }
    }
}

/**
 * MindSet
 * @author Yukiya Okuda<alumican.net>
 */
import com.adobe.serialization.json.JSON;
import com.adobe.serialization.json.JSONParseError;
import flash.events.ErrorEvent;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.events.ProgressEvent;
import flash.events.SecurityErrorEvent;
import flash.net.Socket;

internal class MindSet extends EventDispatcher
{
    //Event
    static public const DATA_SIGNAL:String = "dataSignal";
    static public const DATA_EEG_RAW:String = "dataEegRaw";
    static public const DATA_EYE_BLINK:String = "dataEyeBlink";
    
    static public const SOCKET_CONNECT:String = "socketConnect";
    static public const SOCKET_ERROR:String = "socketError";
    static public const SOCKET_CLOSE:String = "socketClose";
    
    //Sensor Value
    public function get signalLevel():Number { return _signalLevel; }
    private var _signalLevel:Number;
    
    public function get attention():Number { return _attention; }
    private var _attention:Number;
    
    public function get meditation():Number { return _meditation; }
    private var _meditation:Number;
    
    public function get lowAlpha():Number { return _lowAlpha; }
    private var _lowAlpha:Number;
    
    public function get highAlpha():Number { return _highAlpha; }
    private var _highAlpha:Number;
    
    public function get lowBeta():Number { return _lowBeta; }
    private var _lowBeta:Number;
    
    public function get highBeta():Number { return _highBeta; }
    private var _highBeta:Number;
    
    public function get lowGamma():Number { return _lowGamma; }
    private var _lowGamma:Number;
    
    public function get highGamma():Number { return _highGamma; }
    private var _highGamma:Number;
    
    public function get delta():Number { return _delta; }
    private var _delta:Number;
    
    public function get theta():Number { return _theta; }
    private var _theta:Number;
    
    public function get rawEeg():Number { return _rawEeg; }
    private var _rawEeg:Number;
    
    public function get blinkStrength():Number { return _blinkStrength; }
    private var _blinkStrength:Number;
    
    //Connector
    private var _socket:Socket;
    
    public function MindSet():void
    {
        _signalLevel = _attention = _meditation = _lowAlpha = _highAlpha = _lowBeta = 
        _highBeta = _lowGamma = _highGamma = _delta = _theta = _rawEeg = _blinkStrength = 0;
        
    }
    
    public function connect():void
    {
        close();
        _socket = new Socket();
        _socket.addEventListener(Event.CONNECT, _socketConnectHandler);
        _socket.addEventListener(ProgressEvent.SOCKET_DATA, _socketDataHandler);
        _socket.addEventListener(IOErrorEvent.IO_ERROR, _socketErrorHandler);
        _socket.addEventListener(SecurityErrorEvent.SECURITY_ERROR, _socketErrorHandler);
        _socket.addEventListener(Event.CLOSE, _socketCloseHandler);
        _socket.connect("127.0.0.1", 13854);
    }
    
    public function close():void
    {
        if (!_socket) return;
        _socket.removeEventListener(Event.CONNECT, _socketConnectHandler);
        _socket.removeEventListener(ProgressEvent.SOCKET_DATA, _socketDataHandler);
        _socket.removeEventListener(IOErrorEvent.IO_ERROR, _socketErrorHandler);
        _socket.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, _socketErrorHandler);
        _socket.removeEventListener(Event.CLOSE, _socketCloseHandler);
        try
        {
            _socket.close();
        }
        catch (erroe:Error) { }
        _socket = null;
    }
    
    //Socket Handler
    private function _socketConnectHandler(e:Event):void 
    {
        _socket.writeUTFBytes(JSON.encode( { enableRawOutput : true, format : "Json" } ));
        dispatchEvent(new Event(SOCKET_CONNECT));
    }
    
    private function _socketErrorHandler(e:ErrorEvent):void 
    {
        close();
        dispatchEvent(new ErrorEvent(SOCKET_ERROR, false, false, e.text));
    }
    
    private function _socketCloseHandler(e:Event):void 
    {
        close();
        dispatchEvent(new Event(SOCKET_CLOSE));
    }
    
    private function _socketDataHandler(e:ProgressEvent):void 
    {
        var packets:Array = _socket.readUTFBytes(_socket.bytesAvailable).split(/\r/);
        _socket.flush();
        
        for each (var packet:String in packets)
        {
            if (packet == "") continue;
            try
            {
                var data:Object = JSON.decode(packet);
                //----------------------------------------
                if (data["poorSignalLevel"] != null)
                {
                    _signalLevel = 1 - data["poorSignalLevel"] / 200; //[0, 1]
                    if(_signalLevel == 0) {
                        _attention = _meditation = _lowAlpha = _highAlpha = _lowBeta = 
                        _highBeta = _lowGamma = _highGamma = _delta = _theta = 0;
                    }
                    else
                    {
                        _attention = data["eSense"]["attention"] / 100; //[0, 1]
                        _meditation = data["eSense"]["meditation"] / 100; //[0, 1]
                        _lowAlpha = data["eegPower"]["lowAlpha"];
                        _highAlpha = data["eegPower"]["highAlpha"];
                        _lowBeta = data["eegPower"]["lowBeta"];
                        _highBeta = data["eegPower"]["highBeta"];
                        _lowGamma = data["eegPower"]["lowGamma"];
                        _highGamma = data["eegPower"]["highGamma"];
                        _delta = data["eegPower"]["delta"];
                        _theta = data["eegPower"]["theta"];
                    }
                    
                    dispatchEvent(new Event(DATA_SIGNAL));
                }
                //----------------------------------------
                if (data["blinkStrength"] != null)
                {
                    _blinkStrength = data["blinkStrength"];
                    dispatchEvent(new Event(DATA_EYE_BLINK));
                }
                //----------------------------------------
                if (data["rawEeg"] != null)
                {
                    _rawEeg = data["rawEeg"];
                    dispatchEvent(new Event(DATA_EEG_RAW));
                }
            }
            catch (error:JSONParseError)
            {
            }                    
        }
    }
}