/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4tYP
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.ProgressEvent;
	import flash.net.FileReference;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;

	/**
	 * ...
	 * @author ue
	 */
	public class Main extends Sprite
	{
		private var _loadFile:FileReference;
		private var _saveFile:FileReference;
		private var _loadButton:Sprite;
		private var _saveButton:Sprite;

		public function Main():void
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}

		private function init(e:Event = null):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			_loadButton = createButton(_loadButton, "load");
			_loadButton.x = 10;
			_loadButton.y = 10;
			addChild(_loadButton);

			_saveButton = createButton(_saveButton, "save");
			_saveButton.x = 120;
			_saveButton.y = 10;
			addChild(_saveButton);

			_loadFile = new FileReference();
			_loadFile.addEventListener(Event.SELECT, onSelect);
			_loadButton.addEventListener(MouseEvent.CLICK, onLoadButton);

			_saveFile = new FileReference();
			_saveButton.addEventListener(MouseEvent.CLICK, onSave);
		}

		private function onSelect(e:Event):void
		{
			e.target.addEventListener(ProgressEvent.PROGRESS, onProgress);
			e.target.addEventListener(Event.COMPLETE, onComplete);
			e.target.load();
		}

		private function onSave(e:Event):void {
			var s:String = "この文字列がテキストファイルとして保存されます"
			_saveFile.save(s,"test.txt");
		}

		private function onProgress(e:ProgressEvent):void
		{
			trace("読み込み完了バイト数：" + e.bytesLoaded + "、全体のバイト数：" + e.bytesTotal);
		}

		private function onComplete(e:Event):void
		{
			trace(e.target.data);
			e.target.removeEventListener(ProgressEvent.PROGRESS, onProgress);
			e.target.removeEventListener(Event.COMPLETE, onComplete);
		}

		private function onLoadButton(e:MouseEvent):void
		{
			_loadFile.browse();
		}

		private function createButton(s:Sprite, label:String = null):Sprite {
			s = new Sprite();
			s.graphics.lineStyle(1, 0xBBBBBB);
			s.graphics.beginFill(0xDDDDDD);
			s.graphics.drawRect(0, 0, 100, 20);
			s.graphics.endFill();
			var t:TextField = new TextField();
			if(label != null){
				t.text = label;
				t.autoSize = TextFieldAutoSize.CENTER;
				t.textColor = 0x333333;
				s.addChild(t);
			}
			return s;
		}
	}
}
