/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4t1F
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.external.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.system.*;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {            
            graphics.beginFill(0);
            graphics.drawRect(0,0,465,465);
            graphics.endFill();
            
            
            forceMap = new BitmapData(465/4,465/4,false,0);
            var bmp:Bitmap = new Bitmap(forceMap);
            bmp.scaleX = bmp.scaleY = 4;
            bmp.alpha=0.3;
            addChild(bmp);
            
            forceMap.perlinNoise(256*2,256*2,2,1,true,true,7);
            
            canvas = new BitmapData(465,465,true,0);
            
            addChild(new Bitmap(canvas));
            addEventListener(Event.ENTER_FRAME,update);
        }
        private var forceMap:BitmapData;
        private var canvas:BitmapData;
        
        private var _particles:Vector.<Particle> = new Vector.<Particle>();
        private function update(e:Event):void{
            var p:Particle, angle:Number;
            if( _particles.length < 500 ) {
                angle = Math.random()*Math.PI*2;
                p = new Particle(
                    mouseX+Math.cos(angle)*20,
                    mouseY+Math.cos(angle)*20
                );
                _particles.push(p);    
            }
            
            draw();
        }
        private var _ctf:ColorTransform = new ColorTransform(0.8,0.8,0.8,0.9);
        private function draw():void{
            canvas.lock();
            canvas.colorTransform(canvas.rect,_ctf);
            //canvas.fillRect(canvas.rect,0);
            var speed:Number = 0.1;
            var c:uint, fx:Number, fy:Number = 0;
            var wx:Number, wy:Number;
            for each(var p:Particle in _particles ){
                c = forceMap.getPixel32(p.x>>2,p.y>>2);
                
                fx = ((c>>16)&0xFF/0xFF) -0.5;
                fy = ((c>> 8)&0xFF/0xFF) -0.5;
                
                wx = 0.05;
                wy = -0.01;
                p.force(wx,fy*speed+wy);
                p.friction(0.97,0.97);
                p.calc();
                
                if( p.x > 465 ) p.x -= 465;
                else if( p.x < 0 ) p.x += 465;
                if( p.y > 465 ) p.y -= 465;
                else if( p.y < 0 ) p.y += 465;
                
                canvas.setPixel32(p.x, p.y, 0xFFFFFFFF);
            }
            canvas.unlock();
        }
        
    }
}

internal class Particle{
    public var x:Number;
    public var y:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Particle(sx:Number, sy:Number) {
        x = sx;
        y = sy;
    }
    
    public function calc():void{
        x += vx;
        y += vy;
    }
    
    public function force(fx:Number,fy:Number):void {
        vx += fx;
        vy += fy;
    }
    public function friction(fx:Number,fy:Number):void {
        vx *= fx;
        vy *= fy;
    }
}