/**
 * Copyright Venom ( http://wonderfl.net/user/Venom )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4scU
 */

/**
 * Jason Smith 2010
 */
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    final public class ColorWheeling extends Sprite {
        private var radius:Number = 50;
        private const blur:BlurFilter = new BlurFilter(3,3,3);
        private const COUNT:uint = 100;
        
        private var bmp:Bitmap;
        private var bmd:BitmapData;
        
        public function ColorWheeling() {
            init();
        }
        
        private function init():void {
            bmd = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
            bmp = new Bitmap(bmd);
            addChild(bmp);
            
            addEventListener("enterFrame",loop,false,0,true);
        }
        
        private var omega:Number = 0;
        private var randomColour:uint = 0xffffff;
        private function loop(evt:Event):void {
            for (var i:uint = 0; i<COUNT; i++) {
                for (var j:uint = 0; j<COUNT; j++) {
                    bmd.setPixel(mouseX+Math.sin(j)*radius,mouseY+Math.cos(j)*radius,randomColour);    
                }
                radius+=Math.cos(omega)*Math.sin(i)*20;
            }
            bmd.applyFilter(bmd,bmd.rect,new Point(),blur);
            
            randomColour = Math.random()*0xffffff;
            omega+=0.2;
        }
    }
}