/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4r5J
 */

// 途中
// 
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
    public class FlashTest extends Sprite
	{
		private var bdView:BitmapData;
		private var redPos:Point;
        public function FlashTest()
		{
			bdView = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
			addChild(new Bitmap(bdView));
			redPos = new Point(465 * .5, 465 * .5);
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private const SCROLL_SPEED:Number = 30;
		private function enterFrameHandler(e:Event):void 
		{
			bdView.lock();
			bdView.scroll(-SCROLL_SPEED, 0);
			bdView.fillRect(new Rectangle(bdView.width - SCROLL_SPEED, 0, SCROLL_SPEED, bdView.height), 0);
			
			var dv:Point = new Point(Math.random() - .5, Math.random() - .5);
			dv.normalize(5);
			dv = dv.add(redPos);
			redPos.x -= SCROLL_SPEED;
			drawLine(bdView, 4, 0xFF0000, redPos, dv);
			redPos = dv;
			
			bdView.unlock();
		}
		
		private function drawLine(bitmapData:BitmapData, thickness:Number, color:uint, startPos:Object, endPos:Object):void
		{
			if (thickness == 0) return;
			var dx:Number, dy:Number;
			var x:Number = endPos.x - startPos.x;
			var y:Number = endPos.y - startPos.y;
			var m:Number = (y == 0 || Math.abs(x / y) >= 1) ? x : y;
			if (m == 0)
			{
				for (dy = -thickness * .5; dy <= thickness * .5; dy++)
				{
					for (dx = -thickness * .5; dx <= thickness * .5; dx++)
					{
						bitmapData.setPixel(startPos.x + dx, startPos.y + dy, color);
					}
				}
				return;
			}
			for (var i:Number = 0; i / m <= 1; i += (m == 0 ? 0 : (m / Math.abs(m))))
			{
				var tx:Number = startPos.x + x / m * i;
				var ty:Number = startPos.y + y / m * i;
				if (thickness == 1 || thickness < 0)
				{
					bitmapData.setPixel(tx, ty, color);
				}
				else
				{
					for (dy = -thickness * .5; dy <= thickness * .5; dy++)
					{
						for (dx = -thickness * .5; dx <= thickness * .5; dx++)
						{
							bitmapData.setPixel(tx + dx, ty + dy, color);
						}
					}
				}
			}
		}
		
    }
}