/**
 * Copyright yun ( http://wonderfl.net/user/yun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4phe
 */

package
{
    import flash.display.Sprite;
    import flash.events.NetStatusEvent;
    import flash.media.Video;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.system.Security;
    
    public class Main extends Sprite
    {
        private var _connection:NetConnection;
        private var _stream:NetStream;
        private var _video:Video = new Video;
        private var _videoURL:String = "http://www.muraken.biz/wonderfl/construction.mp4";
        
        public function Main():void
        {
            Security.loadPolicyFile("http://www.muraken.biz/crossdomain.xml");
            _connection = new NetConnection();
            _connection.addEventListener( NetStatusEvent.NET_STATUS, _netStatusHandler );
            _connection.connect( null );
        }
        
        private function _netStatusHandler( e:NetStatusEvent ):void {
            if( e.info.code=="NetConnection.Connect.Success" ) {
                _connectStream();
            }
        }
        
        private function _connectStream():void {
            _stream = new NetStream( _connection );
            _stream.addEventListener( NetStatusEvent.NET_STATUS, _netStatusHandler );
            _stream.client = this;
            
            addChild( _video );
            _video.attachNetStream( _stream );
            _video.x = Math.floor( ( stage.stageWidth - _video.width ) / 2 );
            _video.y = Math.floor( ( stage.stageHeight - _video.height ) / 2 );
            _stream.play( _videoURL );
        }
        
        // callback
        public function onMetaData( info:Object ):void {}
        public function onCuePoint( info:Object ):void {}
        public function onXMPData( info:Object ):void {}
    } 
}