/**
 * Copyright h_ike ( http://wonderfl.net/user/h_ike )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4pgG
 */

package {
	import flash.display.*;
	import flash.events.*;
	import org.papervision3d.core.math.Plane3D;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.lights.PointLight3D;
	
	[SWF(width = "1024", height = "568", backgroundColor = "#333333", frameRate = "50")]
	
	public class Main extends Sprite {
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var viewport:Viewport3D;
		private var renderer:BasicRenderEngine;
		
		private var stageW:Number;
		private var stageH:Number;
		private var vpX:Number;
		private var vpY:Number;
		private var array:Array;
		private var radius:Number = 40;
		private var xNum:Number = 10;
		private var zNum:Number = 10;
		private var intervalX:Number = 2;
		private var intervalZ:Number = 2;
		private var centerX:Number;
		private var centerZ:Number;
		private var light:PointLight3D;
		
		public function Main() {
			init();
		}
		private function init():void {
			setStage();
			setScene();
			setCamera();
			setDO3D();
			
			addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
		}
		private function setStage():void {
			stage.quality = StageQuality.MEDIUM;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stageW = stage.stageWidth;
			stageH = stage.stageHeight;
			vpX = stageW / 2;
			vpY = stageH / 2;
		}
		private function setScene():void {
			renderer = new BasicRenderEngine();
			scene = new Scene3D();
			viewport = new Viewport3D(0, 0, true, true);
			addChild(viewport);
		}
		private function setCamera():void {
			camera = new Camera3D();
			camera.x = 0;
			camera.y = 100;
			camera.z = -600;
			camera.zoom = 30;
			camera.focus = 30;
			var target:DisplayObject3D = new DisplayObject3D();
			target.y = 150;
			camera.target = target;
		}
		private function setDO3D():void {
			array = new Array();
			centerX = ((intervalX + radius) * (xNum -1)) / 2;
			centerZ = ((intervalZ + radius) * (zNum - 1)) / 2;
			light = new PointLight3D(true);
			light.y = 300;
			var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xffffff, 0x333333);
			var mlist:MaterialsList = new MaterialsList( { all:material } );
			for (var i:int = 0; i < zNum; i++) {
				for (var j:int = 0; j < xNum; j++) {
					var cube:Cube = new Cube(mlist, radius, radius,radius,1,1,1);
					cube.x = (intervalX + radius) * i - centerX;
					cube.z = (intervalZ + radius) * j - centerZ;
					scene.addChild(cube);
					array.push(cube);
				}
			}
			var materialForPlane:WireframeMaterial = new WireframeMaterial(0xcccccc);
			materialForPlane.oneSide = false;
			var plane:Plane = new Plane(materialForPlane, 1000, 1000, 8, 8);
			scene.addChild(plane);
			plane.rotationX = 90;
		}
		private function onEnterFrameHandler(event:Event):void {
			var angleX:Number = (mouseX - vpX) * 0.0001;
			var angleY:Number = (mouseY -vpY) * 0.0001;
			moveCameraX(angleX);
			moveCameraY(angleY);
			doMotion3D();
			renderer.renderScene(scene, camera, viewport);
		}
		private function moveCameraX(angleX:Number):void {
			var cosX:Number = Math.cos(angleX);
			var sinX:Number = Math.sin(angleX);
			camera.x = camera.x * cosX - camera.z * sinX;
		}
		private function moveCameraY(angleY:Number):void {
			var cosY:Number = Math.cos(angleY);
			var sinY:Number = Math.sin(angleY);
			camera.y = camera.y * cosY - camera.z * sinY;
		}
		private function doMotion3D():void {
			var cycle:Number = 2;
			var msec:Number = new Date().getTime();
			
			for (var i:int = 0; i < array.length; i++) {
				array[i].y = 40 * Math.cos(i % xNum) * Math.sin(msec / 1000 * Math.PI * 2 / cycle) + 150;
				//array[i].y = 20 * (i / (i % xNum)) * Math.sin(msec / 1000 * Math.PI * 2 / cycle * Math.cos(i) );
				//array[i].rotationY = 180 * Math.sin(msec / 1000 * Math.PI * 2 / cycle*(i/(zNum*2)))
			}
		}
	}
}