/**
 * Copyright paulstamp1 ( http://wonderfl.net/user/paulstamp1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4p4P
 */

// forked from paulstamp1's Orbit
/**                                                          
     _____ _____ _____ __       _____ _____ _____ _____ _____ 
    |  _  |  _  |  |  |  |     |   __|_   _|  _  |     |  _  |
    |   __|     |  |  |  |__   |__   | | | |     | | | |   __|
    |__|  |__|__|_____|_____|  |_____| |_| |__|__|_|_|_|__|   
    @paulstamp
                                                       
    Random colourful triangle pattern :-)

*/
package {
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.geom.Rectangle;
    
    public class FlashTest extends Sprite {
        
        private var _colorArray:Array = new Array(0xFFFF33, 0xFFFFFF, 0x79DCF4, 0xFF3333, 0xFFCC33, 0x99CC33);
        
        public function FlashTest() {
            // write as3 code here..
            createTriangleMesh();
        }
        
        public function createTriangleMesh():void
        {
            var bounds:Rectangle = new Rectangle(0,0, stage.stageWidth, stage.stageHeight );
            var points:Vector.<Point> = randomPointsWithin( 800, bounds );
            drawLines( points );
        }
        
        public function drawLines( points:Vector.<Point> ):void
        {
            //this.graphics.lineStyle(1,0);
            var distances:Array; 
            var origin:Point;
            
            for( var i:uint = 0; i < points.length; i++ )
            {
                origin = points[i];
                distances = [];
                
                for each( var point:Point in points)
                    distances.push( {distance:Point.distance( origin, point ), point:point} );
                
                distances.sortOn( "distance", Array.NUMERIC );
                
                
                //link points
                this.graphics.beginFill( randomColor );
                this.graphics.moveTo( origin.x, origin.y );
                this.graphics.lineTo( distances[1].point.x, distances[1].point.y );
                this.graphics.lineTo( distances[2].point.x, distances[2].point.y );
                this.graphics.lineTo( origin.x, origin.y );
                this.graphics.endFill();
            }
        }
        
        public function get randomColor():uint
        {            
            return _colorArray[Math.floor(Math.random()*_colorArray.length)];
        }




        public function randomPointsWithin( quantity:uint, bounds:Rectangle ):Vector.<Point>
        {
            var points:Vector.<Point> = new Vector.<Point>();
            
            for( var i:uint = 0; i < quantity; i++ )
            {
                points.push( randomPointWithin( bounds ));
            }
            
            return points;
        }

        public function randomPointWithin( bounds:Rectangle ):Point
        {
            var rx:Number = randomRange( bounds.x, bounds.x + bounds.width );
            var ry:Number = randomRange( bounds.y, bounds.y + bounds.height );
            return new Point( rx, ry );
        }
        
        public function randomRange(max:Number, min:Number = 0):Number
        {
             return Math.random() * (max - min) + min;
        }


    }
}