/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4oZs
 */

/*
 * バーコードリーダーPS-800Pを購入したの試してみた。
 * http://www.amazon.co.jp/dp/B002C1SPBQ/
 * 
 * USBキーボードのキーイベントとして取れるので、ドライバ不要で、すぐに使えた。
 * 
 * とりあえず、バーコード読み取り→改行コードを受け取ったら、
 * コードを判別して、書籍なら書籍用APIに、それ以外の商品ならYahooに
 * 問い合わせる。
 * 
 * 
 * API
 * http://d.hatena.ne.jp/eiji8pou/20070703/1183458537
 * FetchData_url(decodeURIComponent)v2
 * http://pipes.yahoo.com/pipes/pipe.info?_id=e01ba793eb504f8c2ee7284b4614ca54
 * 
 * http://developer.yahoo.co.jp/webapi/shopping/shopping/v1/itemlookup.html
 * 
 * 参考
 * http://www.uraken.net/zatsugaku/zatsugaku_109.html
 * */
package
{
	import flash.display.Sprite;
	import flash.events.KeyboardEvent;
 
	public class Main extends Sprite
	{
		private var _string:String;
		private var _loadPublisher:LoadPublisher;
		public function Main() {
			_string = "";
			_loadPublisher = new LoadPublisher();
			this.addChild(_loadPublisher);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
		}
		
		private function onKeyDown(event:KeyboardEvent):void {
			if (event.keyCode == 13) {
				trace(_string);
				_loadPublisher.getPublisher(_string);
				_string = "";
			}else {
				_string += String.fromCharCode(event.keyCode);
			}
		}
	}
}

import com.adobe.serialization.json.JSON;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.MouseEvent;
import flash.display.Loader;
import flash.net.URLRequest;
import flash.net.URLLoader;
import flash.text.TextField;
import flash.text.TextFormat;
/**
 * ...
 * @author umhr
 */
[SWF(backgroundColor="0xEEEEEE")]
class LoadPublisher extends Sprite {
	private var _textField:TextField;
	private var _codeTF:TextField;
	public function LoadPublisher():void {
		_codeTF = new TextField();
		_codeTF.defaultTextFormat = new TextFormat("_sans", 12, 0, true);
		_codeTF.width = 465;
		_codeTF.text = "準備完了。Flashのステージをクリックしてからバーコードを読んでください。";
		addChild(_codeTF);
		_textField = new TextField();
		_textField.multiline = true;
		_textField.wordWrap = true;
		_textField.y = 20;
		_textField.width = 465;
		_textField.height = 465;
		addChild(_textField);
	}
	public function getPublisher(code:String):void {
		_codeTF.text = "Code:" + code;
		//ドキュメントルートのcrossdomain.xml（http://pipes.yahooapis.com/crossdomain.xml）で
		//許可を与えているので、特に指定しなくても自動的に許可を取ってくる。
		var myURLLoader:URLLoader = new URLLoader();
		var xmlURL:String;
		if (int(code) == 0) {
			_textField.text = "特殊なコードは対応してないんです。";
			return;
		}else if (code.substr(0, 3) == "491") {
			_textField.text = "雑誌は対応してないんです。";
			return;
		}else if (code.substr(0, 3) == "978") {
			//本（isbn）の場合
			myURLLoader.addEventListener (Event.COMPLETE, onCompleteISBN13JSON);
			//YahooPipesの汎用dataProxy
			xmlURL = "http://pipes.yahooapis.com/pipes/pipe.run?_id=e01ba793eb504f8c2ee7284b4614ca54&_render=json&url=";
			//encodeURIComponentでエスケープして、feedProxyにくっつける。
			xmlURL += encodeURIComponent(encodeURIComponent("http://roboko.s212.xrea.com/publisher.cgi?method="+"isbn13"+"&code="));
			xmlURL += code.substr(0, 13);
		}else {
			//本位外（jan）の場合
			myURLLoader.addEventListener (Event.COMPLETE, onCompletejanJSON);
			var appId:String = "vaSj7BOxg66o5HyvoZNcYUNiJEnzGnxJuQXKy5nuune_2XDHynZg50Y3ORQtZw0LaQqF";
			xmlURL = "http://shopping.yahooapis.jp/ShoppingWebService/V1/json/itemSearch?appid=" +appId + "&jan=" + code;
		
		}
		myURLLoader.load(new URLRequest(xmlURL));
	}
	private function onCompletejanJSON(event:Event):void {
		var data:Object = JSON.decode(URLLoader(event.target).data);
		var str:String = "";
		if(data.ResultSet["0"].Result["0"].Name){
			str += Utils.dump(data.ResultSet["0"].Result["0"].Name);
			str += "<br /><br />";
		}
		if(data.ResultSet["0"].Result["0"].Description){
			str += Utils.dump(data.ResultSet["0"].Result["0"].Description);
			str += "<br /><br />";
		}
		if(data.ResultSet["0"].Result["0"].Url){
			str += "<a href='" + data.ResultSet["0"].Result["0"].Url + "'>"+data.ResultSet["0"].Result["0"].Url+"</a>";
			str += "<br /><br />";
		}
		if(data.ResultSet["0"].Result["0"].Image && data.ResultSet["0"].Result["0"].Image.Medium){
			str += "<img src='" + data.ResultSet["0"].Result["0"].Image.Medium + "'>";
		}
		if (str == "") {
			str = "見つかりませんでした。";
		}
		
		_textField.htmlText = str;
		Utils.dump(data);
	}
	
	private function onCompleteISBN13JSON(event:Event):void {
		var data:Object = JSON.decode(URLLoader(event.target).data);
		if (data.value.items.length > 0) {
			_textField.text = Utils.dump(data.value.items["0"].publisher);
		}else {
			_textField.text = "見つかりませんでした。";
		}
	}
}


	import flash.utils.getQualifiedClassName;
	
	class Utils {
		public function Utils():void { };
		//shuffle
		static public function shuffle(num:int):Array {
			var _array:Array = new Array();
			for (var i:int = 0; i < num; i++) {	
				_array[i] = Math.random();
			}
			return _array.sort(Array.RETURNINDEXEDARRAY);
		}
		//Dump
		static public function dump(obj:Object, isTrace:Boolean = true):String {
			var str:String = returnDump(obj)
			if (isTrace) {
				trace(str);
			}
			return str;
		}
		static public function returnDump(obj:Object):String {
			var str:String = _dump(obj);
			if (str.length == 0) {
				str = String(obj);
			}else if (getQualifiedClassName(obj) == "Array") {
				str = "[\n" + str.slice( 0, -2 ) + "\n]";
			}else {
				str = "{\n" + str.slice( 0, -2 ) + "\n}";
			}
			return str;
		}
		
		static public function traceDump(obj:Object):void {
			trace(returnDump(obj));
		}
		
		static private function _dump(obj:Object, indent:int = 0):String {
			var result:String = "";
			
			var da:String = (getQualifiedClassName(obj) == "Array")?'':'"';
			
			var tab:String = "";
			for ( var i:int = 0; i < indent; ++i ) {
				tab += "    ";
			}
			
			for (var key:String in obj) {
				if (typeof obj[key] == "object") {
					var type:String = getQualifiedClassName(obj[key]);
					if (type == "Object" || type == "Array") {
						result += tab + da + key + da + ":"+((type == "Array")?"[":"{");
						var dump_str:String = _dump(obj[key], indent + 1);
						if (dump_str.length > 0) {
							result += "\n" + dump_str.slice(0, -2) + "\n";
							result += tab;
						}
						result += (type == "Array")?"],\n":"},\n";
					}else {
						result += tab + '"' + key + '":<' + type + ">,\n";
					}
				}else if (typeof obj[key] == "function") {
					result += tab + '"' + key + '":<Function>,\n';
				}else {
					var dd:String = (typeof obj[key] == "string")?"'":"";
					result += tab + da + key + da + ":" + dd + obj[key] +dd + ",\n";
				}
			}			
			return result;
		}
	}
