/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4oUK
 */

// forked from mex's 【AS100本ノック】6回目：爽快
/* 
 * AS100本ノック
 * 6回目のお題は「爽快」
 * あなたなりの「爽快」を表現してください。
 * 
 * 気分爽快な入浴剤。
 */
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.filters.BlurFilter;
	/**
	 * @author Mao Takagi
	 */
	public class Main extends Sprite 
	{
		public var stageW:uint;
		public var stageH:uint;
		
		private var _dis:Number;
		private var _margin:Number;
		private var _pointMax:Number;
		private var _realPoint:Number;
		private var _baseWidth:Number;
		private var _waveArray:Vector.<WaveBase>;
		private var _midArray:Vector.<Point>;
		private var _waveContainer:Sprite;
		public var nowBall:Sprite;
		
		/**
		 * constructor
		 */
		public function Main():void 
		{
			stageW = 465;
			stageH = 465;
			
			_dis = 18;
			_margin = 4;
			_pointMax = 30;
			_realPoint = _pointMax + _margin;
			_baseWidth = stageW / _pointMax;
			_waveArray = new Vector.<WaveBase>();
			_midArray = new Vector.<Point>();
			nowBall = new Sprite();
			_waveContainer = new Sprite();
			_waveContainer.x = -_baseWidth * (_margin / 2);
			_waveContainer.y = (stageH / 10) * 2;
			addChild(_waveContainer);
			
			filters = [new BlurFilter()];
			
			init();
		}
		/**
		 * init
		 */
		private function init():void 
		{
			setWave();
			setBall();
			_waveContainer.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		/**
		 * 波をセット
		 */
		private function setWave():void 
		{
			var i:uint = 0;
			var base:WaveBase;
			for (i = 0; i < _realPoint + 1; i++) 
			{
				base = new WaveBase(this, i, stageW / _pointMax);
				base.x = i * (stageW / _pointMax);
				_waveContainer.addChild(base);
				_waveArray.push(base);
			}
			for (i = 0; i < _realPoint + 1; i++) 
			{
				base = _waveArray[i];
				var id:uint = base.id;
				if (id + 1 < _realPoint - 1) base.next = _waveArray[id + 1];
				if (id - 1 >= 0) base.prev = _waveArray[id - 1];
			}
		}
		/**
		 * ボールを落とす
		 */
		private function setBall():void 
		{
			var randNum:Number = Math.floor(Math.random() * (_pointMax - 2)) + 1;
			var ball:Ball = new Ball(this, _waveContainer);
			nowBall = ball;
			ball.addEventListener(ball.ERASE, function():void
			{
				ball.removeEventListener(ball.ERASE, arguments.callee);
				removeChild(ball);
				setBall();
			});
			ball.x = randNum * _baseWidth;
			addChild(ball);
		}
		/**
		 * 毎フレーム水面を描画
		 * @param event Event
		 */
		private function enterFrameHandler(event:Event):void
		{
			var i:uint = 0;
			_waveContainer.graphics.clear();
			for (i = 0; i < _realPoint; i++) 
			{
				_midArray[i] = new Point(0, 0);
				if (i < _realPoint - 1)
				{
					_midArray[i].x = (_waveArray[i].x + _waveArray[i + 1].x) / 2;
					_midArray[i].y = (_waveArray[i].y + _waveArray[i + 1].y) / 2;
				}
			}
			_waveContainer.graphics.beginFill(0x66CCCC);
			_waveContainer.graphics.lineTo(_waveArray[0].x, _waveArray[0].y);
			for (i = 0; i < _realPoint - 1; i++) 
			{
				_waveContainer.graphics.curveTo(_waveArray[i].x, _waveArray[i].y, _midArray[i].x, _midArray[i].y);
			}
			_waveContainer.graphics.lineTo(stageW + _baseWidth * _margin, 0);
			_waveContainer.graphics.lineTo(stageW + _baseWidth * _margin, (stageH / 10) * 8);
			_waveContainer.graphics.lineTo(0, (stageH / 10) * 8);
			_waveContainer.graphics.lineTo(_waveArray[0].x, _waveArray[0].y);
			_waveContainer.graphics.endFill();
		}
	}
}

/**
 * 波のベースになるDisplayObject
 */
import flash.display.Sprite;
class WaveBase extends Sprite
{
	public const HIT:String = "hit";
	
	private var _container:*;
	private var _id:uint;
	private var _moveRate:Number;
	private var _yRate:Number;
	private var _accel:Number;
	private var _range:Number;
	private var _rate:Number;
	private var _next:WaveBase;
	private var _prev:WaveBase;
	
	public function set id(val:uint):void { _id = val; };
	public function get id():uint { return _id; };
	public function set moveRate(val:Number):void { _moveRate = val; };
	public function get moveRate():Number { return _moveRate; };
	
	public function set next(val:WaveBase):void { _next = val; };
	public function get next():WaveBase { return _next; };
	public function set prev(val:WaveBase):void { _prev = val; };
	public function get prev():WaveBase { return _prev; };
	/**
	 * constructor
	 */
	public function WaveBase(container:*, id:uint, w:Number)
	{
		_container = container;
		_id = id;
		_moveRate = 0;
		_yRate = 0;
		_accel = 0.96;
		_range = 0.32;
		_rate = 0.1;
		
		graphics.drawRect(-w / 2, 0, w, 10);
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	/**
	 * enterFrameHandler
	 * @param event Event
	 */
	private function enterFrameHandler(event:Event):void 
	{
		if (_container.nowBall)
		{
			var ball:Ball = _container.nowBall;
			if (hitTestObject(ball))
			{
				_moveRate = _moveRate + ball.weight;
			}
			_moveRate = _moveRate * _range;
			_yRate = _yRate * _accel + (_moveRate - y) * _rate;
			y = y + _yRate;
			
			if (next) next.moveRate = next.moveRate + _moveRate;
			if (prev) prev.moveRate = prev.moveRate + _moveRate;
		}
	}
}

/**
 * ボール
 */
import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITween;
class Ball extends Sprite
{
	public const ERASE:String = "erase";
	
	private var _container:Main;
	private var _wave:Sprite;
	private var _scale:Number;
	private var _weight:Number;
	private var _scaleMax:Number;
	private var _scaleMin:Number;
	
	public function get weight():Number { return _weight; };
	/**
	 * constructor
	 */
	public function Ball(container:Main, wave:Sprite)
	{
		_container = container;
		_wave = wave;
		_scaleMax = 1.3;
		_scaleMin = 0.9;
		_scale = Math.floor(Math.random() * (_scaleMax - _scaleMin + 1)) + _scaleMin;
		_weight = _scale * 100 / 9;
		
		graphics.beginFill(0xFFFFFF);
		graphics.lineStyle(5, 0x66CCCC);
		graphics.drawCircle(-5, -5, 20);
		graphics.endFill();
		scaleX = scaleY = _scale;
		
		var first:ITween = BetweenAS3.tween(this, { y:_wave.y + 150 }, null, 0.5);
		first.addEventListener(TweenEvent.COMPLETE, function(event:TweenEvent):void
		{
			addEventListener(Event.ENTER_FRAME, emitBubble);
		});
		var second:ITween = BetweenAS3.tween(this, { y:_wave.y + 300, alpha:0, scaleX:0.3, scaleY:0.3 }, null, 8);
		var t:ITween = BetweenAS3.serial(first, second );
		t.addEventListener(TweenEvent.COMPLETE, function(event:TweenEvent):void
		{
			removeEventListener(Event.ENTER_FRAME, emitBubble);
			dispatchEvent(new Event(ERASE));
		});
		t.play();
	}
	/**
	 * emitBubble
	 * @param event Event
	 */
	private function emitBubble(event:Event):void 
	{
		var bubble:Bubble = new Bubble(_container, y, alpha);
		bubble.x = x + Math.floor(Math.random() * (width - 3)) - width / 2;
		_container.addChild(bubble);
	}
}
/**
 * バブル
 */
import flash.display.Sprite;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITween;
class Bubble extends Sprite
{
	private var _container:Main;
	/**
	 * constructor
	 * @param container
	 */
	public function Bubble(container:Main, initY:Number, initAlpha:Number)
	{
		_container = container;
		graphics.beginFill(0xFFFFFF);
		graphics.drawCircle( -1, -1, 2);
		graphics.endFill();
		
		y = initY;
		alpha = initAlpha;
		var me:Bubble = this;
		var time:uint = Math.floor(Math.random() * 3) + 2;
		var t:ITween = BetweenAS3.tween(this, { y:initY - 180, alpha:0 }, null, time);
		t.addEventListener(TweenEvent.COMPLETE, function(event:TweenEvent):void
		{
			t.removeEventListener(TweenEvent.COMPLETE, arguments.callee);
			_container.removeChild(me);
		});
		t.play();
	}
}
