/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4oTT
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class FlashTest extends Sprite
    {
        public function FlashTest()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            graphics.clear();
            graphics.lineStyle(1, 0, 0.75);
            graphics.drawRect(0, 0, 464, 464);
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            Buffer.buildContext(this);
            
            _init();
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.geom.*;
import flash.text.*;

class Buffer
{
    public static var context :Object;
    public static var content :Array;
    
    public static function buildContext($context:Object) :void
    {
        context = $context;

        context.addChild(new Radar);
        context.addChild(new Node);
    }

}

class Node extends Sprite
{
    protected var _x:Number;
    protected var _y:Number;
    protected var _r:Number;
    
    public function Node($x:Number = 232.5, $y:Number = 232.5, $r:Number = 6)
    {
        _x = $x;
        _y = $y;
        _r = $r;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }

    public function _init() :void
    {
        graphics.clear();
        graphics.beginFill(0, 0.33);
        graphics.drawCircle(_x, _y, _r);
        graphics.endFill();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
    }
}

class Radar extends Sprite
{
    protected var _x:Number;
    protected var _y:Number;
    protected var _w:Number;
    protected var _h:Number
    protected var _alpha:Number; 
    protected var _control:Point; 
    
    public function Radar($a:Number = 0.75, $w:Number = 80, $h:Number = 80, $x:Number = 2, $y:Number = 2)
    {
        _x = $x;
        _y = $y;
        _w = $w;
        _h = $h;
        _alpha = $a;
        _control = new Point(232.5, 232.5);
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);    
    }
    
    public function _init() :void
    {
        graphics.clear();
        graphics.lineStyle(2, 0, 0.5);
        graphics.drawRect(_x, _y, _w, _h);
        
        graphics.lineStyle(1, 0, 0.1);
        graphics.moveTo(42, (_y / 2));
        graphics.lineTo(((_w * 2) + 1), _y);
        graphics.moveTo(_x, 3);
        graphics.lineTo(_x, ((_w * 2) + 1));
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        
        addChild(new Node(5, 5));
        
        _init();
        
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        _control = new Point($e.stageX, $e.stageY);
    }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _content = $content;
        _x = $x;
        _y = $y;
        _font = $font;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        text = _content;
        x = _x;
        y = _y;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set font($:String) :void
    { _font = $; _init(); }
    public function set content($:String) :void
    { _content = $; _init(); }
}
