/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4nko
 */

package {
  import flash.display.Sprite;

  import funnel.*;
  import funnel.gui.ArduinoGUI;

  import org.si.sion.SiONDriver;

  public class DetectTouch extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // タッチセンサモジュールに接続したピン
    private var sensorPin:Pin;

    // SiONドライバ
    private var driver:SiONDriver;

    public function DetectTouch() {
      // センサに接続したピンのモードを入力にセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(2, IN);
      arduino = new Arduino(config);

      // センサに接続したピンを初期化してイベントリスナをセット
      sensorPin = arduino.digitalPin(2);
      sensorPin.addEventListener(PinEvent.RISING_EDGE, 
                                 onTouch);

      var gui:ArduinoGUI = new ArduinoGUI();
      this.addChild(gui);
      arduino.gui = gui;

      // SiONドライバのインスタンスを生成して音声ストリーミングを開始
      driver = new SiONDriver();
      driver.play();
    }

    // センサの値が0から1に変化すると呼ばれる
    private function onTouch(e:PinEvent):void {
      // ノートナンバー84（C5）デフォルトの音色（矩形波）で16分音符の1/4だけ発音
      driver.noteOn(84, null, 0.25);
    }
  }
}
