/**
 * Copyright alwAYs ( http://wonderfl.net/user/alwAYs )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4nSt
 */

// forked from yasai's 思春期
/**
 * もっとハートや星が飛び散ったりとかしたいです
 */ 
package {
    import com.flashdynamix.motion.TweensyTimeline;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import com.flashdynamix.motion.Tweensy;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.geom.Point;
    public class FlashTest extends Sprite {
        private const TEXT:String = "思春期の青少年の脳内"
        private var textCount:int = 0;
        private var prevP:Point;
        private var size:int = 30;
        private var color:uint = 0xFF33CC;
        private var background:uint = 0xFFCCFF;
        public function FlashTest() {
            // write as3 code here..
            graphics.beginFill(background);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            prevP = new Point(0,0);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
        
        private function enterFrameHandler(e:Event):void {
            var bitmap:Bitmap = createBitmap();
            bitmap.x = mouseX - bitmap.width / 2;
            bitmap.y = mouseY - bitmap.height / 2;
            addChild(bitmap);
            var timeline:TweensyTimeline = Tweensy.to(bitmap, { alpha:0 }, 2);
            timeline.onComplete = function():void {removeChild(bitmap)};
        }
        
        private function mouseMoveHandler(e:MouseEvent):void {
            var count:int = textCount;
            var bitmap:Bitmap = createBitmap();
            if(prevP.x - (bitmap.width / 2) > mouseX || prevP.x + (bitmap.width * 1.5) < mouseX || prevP.y - (bitmap.height / 2) > mouseY || prevP.y + (bitmap.height * 1.5) < mouseY){
                bitmap.x = mouseX - bitmap.width / 2;
                bitmap.y = mouseY - bitmap.height / 2;
                prevP.x = bitmap.x;
                prevP.y = bitmap.y;
                addChild(bitmap);
                var timeline:TweensyTimeline = Tweensy.to(bitmap, { alpha:0 }, 3);
                timeline.onComplete = function():void { removeChild(bitmap) };
            } else {
                trace("non");
                textCount = count;
            }
        }
        
        private function createBitmap():Bitmap {
            var b:Bitmap = new Bitmap(createBitmapData(createTextField()));
            return b;
        }
        
        private function createBitmapData(tf:TextField):BitmapData {
            var bd:BitmapData = new BitmapData(tf.width, tf.height, true, 0x00);
            bd.draw(tf);
            return bd;
        }
        
        private function createTextField():TextField {
            if (textCount > TEXT.length) textCount = 0;
            var t:TextField = new TextField();
            t.defaultTextFormat = new TextFormat(null, size, color);
            t.text = TEXT.charAt(textCount++);
            t.autoSize = "left";
            return t;
        }
    }
}
