/**
 * Copyright atsumo ( http://wonderfl.net/user/atsumo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4muF
 */

// forked from checkmate's fladdict challenge for amateurs
/**
 * Every frame you get screen caputre of the stage.
 * Generate new frame image with using last frames screen capture.
 * This is a starting point of recursive generative art.
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    public class Beginner extends Sprite {
        /**
         * Overwrite this update function.
         * Every frame the function is invoked with two bitmaps.
         * First one contains reference to the stage bitmap.
         * Second one contains static copy of stage.
         */
         
        public var canvas:BitmapData;
        public var drawHere:BitmapData;
        public var mat:Matrix;
        private var _randomP:Point = new Point(stage.stageWidth*Math.random(),stage.stageHeight*Math.random());
         
        public function update():void{
            drawStep();
            transformStep();
            
            renderStep();
            fadeStep();
        }
        
        
        public function drawStep():void {
            //drawHere.setPixel(stage.mouseX, stage.mouseY, 0xFFFFFFFF*Math.random());
            drawHere.setPixel( Math.random()*480, Math.random()*480, 0xffffff*Math.random());
        }
    
        private var _speedX:Number = 5*Math.random();
        private var _speedY:Number = 5*Math.random();
        public function transformStep():void
        {
        	if(_randomP.x > stage.stageWidth || _randomP.x < 0)
        		_speedX = -_speedX;
        	if(_randomP.y > stage.stageHeight || _randomP.y < 0)
        		_speedY = -_speedY;
        	
        	_randomP.x += _speedX*Math.random();
        	_randomP.y += _speedY*Math.random();
        	
            mat = new Matrix();
            mat.translate(-_randomP.x,-_randomP.y);
            mat.scale(Math.pow(Math.random(),Math.random()),Math.pow(Math.random(),Math.random()));
            mat.rotate(360*Math.random());
            mat.translate(_randomP.x,_randomP.y);
        }
        
        
        public function renderStep():void{
            canvas.draw(drawHere, mat, null,BlendMode.SCREEN);
        }
        
        
        public function fadeStep():void
        {
            canvas.colorTransform(drawHere.rect, new ColorTransform(Math.random()*0.4+0.6,Math.random()*0.4+0.6,Math.random()*0.4+0.6,1,0,0,0,0));
        }
        
        
        /**
         * ---------------------------------------
         * DO NOT CHANGE FOLLOWING CODES
         * DO NOT ACCESS FOLLOWING PROPERTIES DIRECTLY
         * ---------------------------------------
        */
        
       
        private var bitmap:Bitmap;
        
        
        public function Beginner() {
            canvas = new BitmapData(480,480,false,0x000000);
            bitmap = new Bitmap(canvas);
            addChild(bitmap);
            addEventListener(Event.ENTER_FRAME, _update);
        }
        
        public function _update(e:Event):void{
            if(drawHere)
                drawHere.dispose();
            drawHere = canvas.clone();
            update();
        }
    }
}
