/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4mpC
 */

package 

{

    import com.bit101.components.CheckBox;

    import com.bit101.components.Panel;

    import com.bit101.components.PushButton;

    

    import flash.display.Bitmap;

    import flash.display.BitmapData;

    import flash.display.Sprite;

    import flash.display.Stage3D;

    import flash.events.Event;

    import flash.display.StageAlign;

    

    import alternativa.engine3d.controllers.SimpleObjectController;

    import alternativa.engine3d.core.Camera3D;

    import alternativa.engine3d.core.Object3D;

    import alternativa.engine3d.core.Resource;

    import alternativa.engine3d.core.View;

    import alternativa.engine3d.materials.FillMaterial;

    import alternativa.engine3d.primitives.Box;

    

    // ドキュメントクラス

    public class CaptureTest extends Sprite

    {

        private var box:Box;

        private var _sp:Sprite;

        private var _bmd:BitmapData;

        private var _bm:Bitmap;

        private var _sp2:Sprite;

        private var scene:Object3D;

        private var camera:Camera3D;

        private var stage3D:Stage3D;

        private var view:View;

        private var controller:SimpleObjectController;

        

        

        public function CaptureTest()

        {

            trace( "CaptureTest.CaptureTest" );

            scene = new Object3D();

            camera = scene.addChild(new Camera3D(1, 10000)) as Camera3D;

            camera.view = new View(465, 465, false, 0x000000);

            view = camera.view;

            addChild(view);

            view.backgroundAlpha = 0;

            

            stage3D = stage.stage3Ds[0];

            stage3D.addEventListener(Event.CONTEXT3D_CREATE, onCreateContext_Handler, false, 0, true);

            stage3D.requestContext3D();

            stage.align = StageAlign.TOP_LEFT;

        }

        

        private function onCreateContext_Handler(e:Event):void 

        {

            stage3D.removeEventListener(Event.CONTEXT3D_CREATE, onCreateContext_Handler);

            

            createUI();

            

            // マテリアルを作成

            var material:FillMaterial = new FillMaterial(0xFF0000, 0.7);

            // プリミティブを作成

            box = new Box(100, 100, 100, 5, 5, 5);

            box.setMaterialToAllSurfaces(material);

            scene.addChild(box).z = 200;

            box.geometry.upload(stage3D.context3D)

            

            for each (var resource:Resource in scene.getResources(true)) {resource.upload(stage3D.context3D);}

            

            _bm = new Bitmap();

            _bm.bitmapData = new BitmapData(160, 320,true,0);

            addChild(_bm).x = 0;

            

            addEventListener(Event.ENTER_FRAME, atPreRender);


        }

        

        private function createUI():void 

        {

            var panel:Panel = new Panel(stage, 0, 0);

            panel.width = 120;

            var btn0:PushButton = new PushButton(panel, 10, 10, "draw", drawHandler);

            var radio:CheckBox = new CheckBox(panel, 10, 50, "isRenderToBitmap",changeRenderModeHandler);

        }

        

        private function changeRenderModeHandler(e:Event):void 

        {

            view.renderToBitmap = e.target.selected;

        }

        

        private function drawHandler(e:Event):void 

        {

            if(view.canvas) _bm.bitmapData = view.canvas.clone();

        }

        

        

        // エンターフレーム

        private function atPreRender(e:Event):void

        {

            camera.render(stage3D);

            

            // ボックスを回転(rotationプロパティはラジアン角)

            box.rotationY += 1 * Math.PI / 180;

            box.rotationZ += 1 * Math.PI / 180;

        }

    }

}

