/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4mlH
 */

package {
	import flash.display.Sprite;
	import flash.display.Graphics;
	import flash.display.BitmapData;
	import flash.geom.Vector3D;
	import flash.events.MouseEvent;
	public class SelectTriangle extends Sprite {
		var mySprite:Sprite = new Sprite();
		var mySprite2:Sprite = new Sprite();
		var myGraphics:Graphics = mySprite.graphics;
		var myGraphics2:Graphics = mySprite2.graphics;
		var myTexture:BitmapData = new BitmapData(100, 100, false, 0x66FFFF);
		var vertices:Vector.<Number> = new Vector.<Number>();
		var indices:Vector.<int> = new Vector.<int>();
		var uvtData:Vector.<Number> = new Vector.<Number>();
		var nX:Number = stage.stageWidth / 2;
		var nY:Number = stage.stageHeight / 2;
		public function SelectTriangle() {
			addChild(mySprite);
			addChild(mySprite2);
			mySprite.x = nX;
			mySprite.y = nY;
			mySprite2.x = nX;
			mySprite2.y = nY;
			mySprite.addEventListener(MouseEvent.CLICK, xSelectTriangle);
			vertices.push(0, 0);
			vertices.push(-50, -50);
			vertices.push(50, -50);
			vertices.push(50, 50);
			vertices.push(-50, 50);
			indices.push(0, 1, 2);
			indices.push(0, 2, 3);
			indices.push(0, 3, 4);
			indices.push(0, 4, 1);
			uvtData.push(0.5, 0.5);
			uvtData.push(0, 0);
			uvtData.push(1, 0);
			uvtData.push(1, 1);
			uvtData.push(0, 1);
			myGraphics.beginBitmapFill(myTexture);
			myGraphics.lineStyle(1, 0x0000FF);
			myGraphics.drawTriangles(vertices, indices, uvtData);
			myGraphics.endFill();
		}
		private function xSelectTriangle(eventObject:MouseEvent):void {
			var nMouseX:Number = eventObject.localX;
			var nMouseY:Number = eventObject.localY;
			var triangle:Vector.<Number> = new Vector.<Number>();
			var nLength:uint = indices.length;
			for (var i:uint = 0; i < nLength; i += 3) {
				var nIndex:uint=indices[i+2]*2;
				for (var j:uint = 0; j < 3; j++) {
					var nBeginX:Number=vertices[nIndex];
					var nBeginY:Number=vertices[nIndex+1];
					nIndex=indices[i+j]*2;
					var nEndX:Number=vertices[nIndex];
					var nEndY:Number=vertices[nIndex+1];
					var bIsRight:Boolean=xIsRight(nEndX-nBeginX,nEndY-nBeginY,nMouseX-nBeginX,nMouseY-nBeginY);
					if (! bIsRight) {
						break;
					}
				}
				if (j==3) {
					for (var n:uint = 0; n < 3; n++) {
						nIndex=indices[i+n]*2;
						triangle.push(vertices[nIndex], vertices[nIndex + 1]);
					}
					myGraphics2.clear();
					myGraphics2.lineStyle(2, 0xFF0000);
					myGraphics2.drawTriangles(triangle);
					break;
				}
			}
		}
		private function xIsRight(ax:Number, ay:Number, bx:Number, by:Number):Boolean {
			/*
			var a:Vector3D=new Vector3D(ax,ay,0);
			var b:Vector3D=new Vector3D(bx,by,0);
			var crossProduct:Vector3D=a.crossProduct(b);
			var bIsRight:Boolean = (crossProduct.z >= 0);
			*/
			var bIsRight:Boolean = (ax * by - ay * bx >= 0);
			return bIsRight;
		}
	}
}