/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4mUp
 */

// forked from ProjectNya's Tatami 畳
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] Tatamiクラスに挑戦！
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1098
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Rectangle;
    import flash.filters.BevelFilter;
    import flash.filters.BitmapFilterType;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var tatami:Tatami;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            var rect:Rectangle = new Rectangle(0, 0, 420, 465);
            tatami = new Tatami(rect);
            tatami.hsv(60, 0.5, 0.4);
            addChild(tatami);
            tatami.x = 20;
            tatami.y = 0;
            var bevel:BevelFilter = new BevelFilter(1, 45, 0xFFFFFF, 0.2, 0x000000, 0.4, 2, 2, 2, 3, BitmapFilterType.INNER, false);
            var frame:Shape = new Shape();
            frame.graphics.beginFill(0x999933);
            frame.graphics.drawRect(0, 0, 15, 465);
            frame.graphics.drawRect(435, 0, 15, 465);
            frame.graphics.endFill();
            frame.filters = [bevel];
            addChild(frame);
            frame.x = 5;
            frame.y = 0;
        }

    }

}



import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.display.BlendMode;
import frocessing.color.ColorHSV;

class Tatami extends Sprite {
    private var rect:Rectangle;
    private var tatami:BitmapData;
    private var stripe:Shape;
    private var noise:BitmapData;
    private var overlay:Shape;
    private static var base:uint = 8;
    private static var size:uint = 240;
    private static var offset:uint = size/base*0.5;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private var color:ColorHSV;

    public function Tatami(r:Rectangle) {
        rect = r;
        color = new ColorHSV();
    }

    public function hsv(h:uint, s:Number, v:Number):void {
        color.hsv(h, s, v);
        draw();
    }
    private function draw():void {
        stripe = new Shape();
        var colors:Array = [sColor, bColor]
        var alphas:Array = [1, 1];
        var ratios:Array = [51, 204];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(size/base, size, 0, -offset, 0);
        stripe.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.REFLECT, InterpolationMethod.RGB, 0);
        stripe.graphics.drawRect(0, 0, rect.width, rect.height);
        stripe.graphics.endFill();
        var blur:BlurFilter = new BlurFilter(12, 0, 3);
        noise = new BitmapData(rect.width, rect.height, false);
        noise.noise(1, 0, 255, 7, true);
        noise.applyFilter(noise, noise.rect, new Point(), blur);
        overlay = new Shape();
        overlay.graphics.beginFill(color.value);
        overlay.graphics.drawRect(0, 0, rect.width, rect.height);
        overlay.graphics.endFill();
        tatami = new BitmapData(rect.width, rect.height, false);
        tatami.draw(stripe);
        tatami.draw(noise, null, null, BlendMode.DIFFERENCE);
        tatami.draw(overlay, null, null, BlendMode.ADD);
        addChild(new Bitmap(tatami));
    }

}
