/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4lxB
 */

/**
 * Youtube動画を自分作業用に連続再生
 * 検索より固定IDを使った動画再生を試してみます、自分用に、、、
 * 
 * Youtubeの動画IDをベタ書きで配列に設定して連続再生しています
 * Youtubeと連携してる？VEVO(とmercuryrecordsuk)のYoutube上動画のIDを配列にして設定しています
 * U2の動画リストを再生します
 * 問題ありそうなら削除します
 * 
 * ↓参考にさせて頂いたコード＆サイト
 * Youtube ActionScript 3.0 API テスト(Fork元のFork元です)
 * http://wonderfl.net/c/vT3j
 * YouTubePlayer API 
 * http://wonderfl.net/c/r5kL
 * YouTube ActionScript 3.0 Player API リファレンス
 * http://code.google.com/intl/ja/apis/youtube/flash_api_reference.html
 */
package {
    
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.Security;
    
    [SWF(backgroundColor="0x000000", frameRate="30", width="640", height="400")]
    public class Index extends Sprite {
        
        private var player:Object;
        private var loader:Loader;
        private var movieIdListIndex:int = 0;
        private const movieIdList:Array = [
            "XmSdTa9kaiQ",    //With Or Without You 
            "co6WMzDOh1o",    //Beautiful Day'
            "GzZWSrr5wFI",    //Where The Streets Have No Name
            "Pu9rQ8lkQ5c",    //Original Of The Species
            "Yi52HjJbwVQ",    //Magnificent 
            "gwKEdFoUB0o",    //Walk On
            "wo-NskE3M2A",    //Window In The Skies (Modernista Version)
            "8xQOb51qZ-c",    //City of Blinding Lights 
            "CuDqHtAR6L8"     //Sometimes You Can't Make It On Your Own 
        ];
 
        /// init
        public function Index() {
            loader = addChild(new Loader()) as Loader;
            loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit, false, 0, true);
            loader.x = 150;
            loader.y = 50;
            //loader.load(new URLRequest("http://www.youtube.com/v/NMNgbISmF4I?version=3&enablejsapi=1")); //Youtubeコントローラー付き 最初はといあえずののIdを設定
            loader.load(new URLRequest("http://www.youtube.com/v/NMNgbISmF4I?version=3")); //Youtubeコントローラー付き 最初はといあえずののIdを設定
        }
        
        
        /// events
        private function onLoaderInit(event:Event):void {
            loader.content.addEventListener("onReady", onPlayerReady);
            loader.content.addEventListener("onError", onPlayerError);
            loader.content.addEventListener("onStateChange", onPlayerStateChange);
            loader.content.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
        }
        
        private function onPlayerReady(event:Event):void {
            // Event.data contains the event parameter, which is the Player API ID 
            // Once this event has been dispatched by the player, we can use
            // cueVideoById, loadVideoById, cueVideoByUrl and loadVideoByUrl
            // to load a particular YouTube video.
            player = loader.content;

            //player.setSize(640, 360);
            player.setSize(352, 230);

            //player.loadVideoById("NMNgbISmF4I", 0, "default"); //Crazy
            //player.loadVideoById("qfNmyxV2Ncw", 0, "default"); //Cryin'
            //player.loadVideoById("CBTOGVb_cQg", 0, "default"); //Ange
            //ect...
            player.loadVideoById(movieIdList[movieIdListIndex], 0, "default"); //１曲目「Crazy」再生
        }
        
        private function onPlayerError(event:Event):void {
            // Event.data contains the event parameter, which is the error code
        }
        
        private function onPlayerStateChange(event:Event):void {
            // Event.data contains the event parameter, which is the new player state
            //プレイヤーの状態を判定
            //未開始（-1）、終了（0）、再生中（1）、一時停止中（2）、バッファリング中（3）、頭出し済み（5）
            if (Object(event).data == "0") { //動画が終了した場合
                movieIdListIndex++;
                if(movieIdListIndex > movieIdList.length - 1) return; //動画IDリストを超えた場合は処理を行わない
                player.loadVideoById(movieIdList[movieIdListIndex], 0, "default");
            }
        }
        
        private function onVideoPlaybackQualityChange(event:Event):void {
            // Event.data contains the event parameter, which is the new video quality
        }
                
    }
    
}
