/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4lcV
 */

package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    
    /**
     * 描画オブジェクトをつかんで移動させる
　　　　* 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private const POINT_NUM:int = 3;
        private var points:Vector.<Sprite>;
        
        public function Main() 
        {
            points = createPoints( POINT_NUM );
            
            points.forEach( function( item:Sprite, index:int, vector:Vector.<Sprite> ):void {
                    
                    addChild( item );
                    item.x = stage.stageWidth / ( vector.length + 1 ) * ( index + 1 );
                    item.y = stage.stageHeight / 2;
                    item.addEventListener(MouseEvent.MOUSE_OVER, pointMouseOverHandler);
                    item.addEventListener(MouseEvent.MOUSE_OUT,  pointMouseOutHandler);
                    item.addEventListener(MouseEvent.MOUSE_DOWN, pointMouseDownHandler);
                    item.addEventListener(MouseEvent.MOUSE_UP,   pointMouseUpHandler);
                } );
        }
        
        private function createPoints( pointNum:int ):Vector.<Sprite> {
            
            var points:Vector.<Sprite> = new Vector.<Sprite>(pointNum);
            points.forEach( function( item:Sprite, index:int, vector:Vector.<Sprite> ):void {
                    
                    item = new Sprite();
                    vector[index] = item;
                    item.graphics.beginFill( 0 );
                    item.graphics.drawCircle( 0, 0, 20 );
                    item.graphics.endFill();
                } );
            
            return points;
        }
        
        
        private function pointMouseOverHandler( event:MouseEvent ):void {
            
            var point:Sprite = event.currentTarget as Sprite;
            point.buttonMode = true;
        }
        
        private function pointMouseOutHandler( event:MouseEvent ):void {
            
            var point:Sprite = event.currentTarget as Sprite;
            point.buttonMode = false;
        }
        
        private var pressedPoint:Sprite;
        private function pointMouseDownHandler( event:MouseEvent ):void {
            
            var point:Sprite = event.currentTarget as Sprite;
            if( !stage.hasEventListener(MouseEvent.MOUSE_MOVE) )
                stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            
            pressedPoint = point;
        }
        
        private function mouseMoveHandler( event:MouseEvent ):void {
            
            pressedPoint.x = event.stageX;
            pressedPoint.y = event.stageY;
        }
        
        private function pointMouseUpHandler( event:MouseEvent ):void {
            
            var point:Sprite = event.currentTarget as Sprite;
            if( stage.hasEventListener(MouseEvent.MOUSE_MOVE) )
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
    }
    
}