/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4l68
 */

package
{
	import flash.events.*;
    import flash.filters.*;
    import flash.utils.*;
	
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.materials.special.LineMaterial;
    import org.papervision3d.core.effects.*;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.materials.*;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.events.TweenEvent;
	
	[SWF(width="465",height="465",backgroundColor="0x000000")]
	public class Laser3D extends BasicView
	{
		static public const OBJ_MAX:int = 300;
		private var _bfx:BitmapEffectLayer;
        private const MAX_RADIUS:int = 5000;
		
		function Laser3D():void
		{
			viewport.opaqueBackground = 0x0;
			var line:Line3D;
			var startV3d:Vertex3D;
			var endV3d:Vertex3D;
			
            var timer:Timer = new Timer(7000);
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start()
			
            _bfx = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight);
            _bfx.addEffect(new BitmapLayerEffect(new BlurFilter(6, 6, 12)));
            viewport.containerSprite.addLayer(_bfx);
			
			var posX:Number;
			var posY:Number;
			var posZ:Number;
			for(var i:uint = 1; i < OBJ_MAX; i++)
			{
				var lines3D:Lines3D;
				lines3D = new Lines3D();
				scene.addChild(lines3D);
           		_bfx.addDisplayObject3D(lines3D);
				
				posX = Math.random() * MAX_RADIUS-MAX_RADIUS/2;
				posY = Math.random() * MAX_RADIUS-MAX_RADIUS/2;
				posZ = Math.random() * MAX_RADIUS-MAX_RADIUS/2;
				startV3d = new Vertex3D(posX, posY, posZ);
				endV3d = new Vertex3D(posX, posY, posZ);
				
				var col:uint = Math.random()*0xff <<16 | Math.random()*0xff << 8 | Math.random()*0xff;
				var material : WireframeMaterial = new WireframeMaterial(col);
				material.doubleSided = true;
				var mySphere:Sphere = new Sphere(material,20,5,5);
				mySphere.x = posX;
				mySphere.y = posY;
				mySphere.z = posZ;
				scene.addChild( mySphere );
				
				var lm:LineMaterial = new LineMaterial(col);
				line = new Line3D(lines3D, lm, 2, startV3d, endV3d);
				lines3D.addLine(line);
				
				var tw:ITween = setTween(lines3D,mySphere);
				tw.addEventListener(TweenEvent.COMPLETE, evCompTween);
				tw.play();
			}
			setTimeout(loop, 100);
			startRendering();
		}
		
        private var dmy: DisplayObject3D = new DisplayObject3D();
		
        private function loop(e:TimerEvent = null):void {
            dmy.moveBackward(800);
			
            BetweenAS3.bezierTo(camera, 
            {
                x : Math.random() * 2000-1000,
                y : Math.random() * 2000-1000,
                z : Math.random() * 2000-1000,
                rotationX : Math.random() * 360,
                rotationY : Math.random() * 360,
                rotationZ : Math.random() * 360
            }, {
                x : Math.random() * 2000-1000,
                y : Math.random() * 2000-1000,
                z : Math.random() * 2000-1000
            },
            6, Quart.easeInOut).play();
		}
		
		private function evCompTween(e:TweenEvent):void{
			e.target.removeEventListener(TweenEvent.COMPLETE, evCompTween);
			var tw:ITween = setTween(e.target.getTweenAt(0).target,e.target.getTweenAt(1).target);
			tw.addEventListener(TweenEvent.COMPLETE, evCompTween);
			tw.play();
		}
		
		private function setTween(obj:DisplayObject3D,obj2:DisplayObject3D):ITween{
			var start:Object = obj.geometry.vertices[0];
			var end:Object = obj.geometry.vertices[1];
			
			var posX:Number = Math.random() * MAX_RADIUS-MAX_RADIUS/2;
			var posY:Number = Math.random() * MAX_RADIUS-MAX_RADIUS/2;
			var posZ:Number = Math.random() * MAX_RADIUS-MAX_RADIUS/2;
			
			var dt1:Number = Math.random() * 3;
			var dt2:Number = Math.random() * 1;
			
			return BetweenAS3.parallel(
					BetweenAS3.tween(obj,{x:obj.x},null,1,Quint.easeInOut),
					BetweenAS3.tween(obj2,{rotationY:Math.random() * 360},null,1,Quint.easeInOut),
					BetweenAS3.delay(
					BetweenAS3.parallel(
						BetweenAS3.tween(obj2,{x:posX},null,1,Quint.easeInOut),
						BetweenAS3.tween(obj2,{y:posY},null,1,Quint.easeInOut),
						BetweenAS3.tween(obj2,{z:posZ},null,1,Quint.easeInOut)
					),dt1),
			BetweenAS3.delay(
			BetweenAS3.parallel(
				BetweenAS3.tween(end,{x:posX},null,1,Quint.easeInOut),
				BetweenAS3.tween(end,{y:posY},null,1,Quint.easeInOut),
				BetweenAS3.tween(end,{z:posZ},null,1,Quint.easeInOut)
								),dt1+dt2),
			BetweenAS3.delay(
			BetweenAS3.parallel(
				BetweenAS3.tween(start,{x:posX},null,1,Quint.easeInOut),
				BetweenAS3.tween(start,{y:posY},null,1,Quint.easeInOut),
				BetweenAS3.tween(start,{z:posZ},null,1,Quint.easeInOut)
								),dt1));
		}

		override protected function onRenderTick(event:Event=null):void
		{
			super.onRenderTick(event);  
		}
	}
}