/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4kVL
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.GouraudMaterial;

    public class FlashTest extends Sprite {
        public function FlashTest() {
            var view:BasicView = new BasicView(465, 465);
            this.addChild(view);
            
            view.camera.zoom = 50;
            
            var container:DisplayObject3D = new DisplayObject3D();
            container.rotationX = -20.0;
            view.scene.addChild(container);

            var light:PointLight3D = new PointLight3D(false);
            light.x = 500;
            light.y = 300;
            light.z = -100;
            container.addChild(light);

            var mat:GouraudMaterial = new GouraudMaterial(light, 0xFF2020);
            var materials:MaterialsList = new MaterialsList();
            materials.addMaterial(mat, "all");
            
            for (var index:uint = 0; index < 5; ++index) {
                var size:Number = 200 - (index * 30);
                var cube:Cube = new Cube(materials, size, size, size);
                cube.x = -400 + (index * 200);
                container.addChild(cube);
            }

            view.startRendering();

            var proc:Function = function(e:Event):void {
                container.rotationY += 1.0;
                container.rotationX += 2.0;
            };
            this.addEventListener(Event.ENTER_FRAME, proc);
        }
    }
}
