/**
 * Copyright kaikoga ( http://wonderfl.net/user/kaikoga )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4jne
 */

// forked from yukoba's copyPixels, getVector, getPixels ベンチマーク
package {
    import flash.filters.ColorMatrixFilter;
    import flash.display.*;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.text.*;
    import flash.utils.*;
    
    [SWF(frameRate=60)]
    public class FlashTest extends Sprite {
        private var tf:TextField = new TextField();
        
        public function FlashTest() {
            addChild(tf);
            tf.autoSize = "left";
            setTimeout(function():void {
                newBitmapDataTest();
                copyPixelsTest();
                copyPixelsMergeAlphaTest();
                copyPixelsAlphaBitmapTest();
                getVectorTest();
                getPixelsTest();
                getPixelTest();
                getPixel32Test();
                copyPixelsWithRepeatTest();
                graphicsBitmapFillWithRepeatTest();
                copyChannelTest();
                colorMatrixFilterTest();
            }, 300);
        }
        
        private function newBitmapDataTest():void {
            var bd1:BitmapData;
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 200; i++) {
                bd1 = new BitmapData(800, 600, true, 0xFFFF0000);
                bd1.dispose();
            }
            
            var time:int = getTimer() - start;
            tf.appendText("new BitmapData(800, 600, true, 0xFFFF0000)\ntime = " + time / 200 + "ms\n\n");
            
            bd1.dispose();
        }

        private function copyPixelsTest():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x80FF0000);
            var bd2:BitmapData = new BitmapData(800, 600, true, 0x8000FF00);
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 200; i++) {
                bd2.copyPixels(bd1, bd1.rect, new Point);
            }
            
            var time:int = getTimer() - start;
            tf.appendText("copyPixels no alpha merge\ntime = " + time / 200 + "ms\n\n");
            
            bd1.dispose();
            bd2.dispose();
        }

        private function copyPixelsMergeAlphaTest():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x80FF0000);
            var bd2:BitmapData = new BitmapData(800, 600, true, 0x8000FF00);
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 200; i++) {
                bd2.copyPixels(bd1, bd1.rect, new Point, null, null, true);
            }
            
            var time:int = getTimer() - start;
            tf.appendText("copyPixels with alpha merge\ntime = " + time / 200 + "ms\n\n");
            
            bd1.dispose();
            bd2.dispose();
        }

        private function copyPixelsAlphaBitmapTest():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x80FF0000);
            var bd2:BitmapData = new BitmapData(800, 600, true, 0x8000FF00);
            var bd3:BitmapData = new BitmapData(800, 600, true, 0x800000FF);
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 100; i++) {
                bd3.copyPixels(bd1, bd1.rect, new Point, bd2, new Point, true);
            }
            
            var time:int = getTimer() - start;
            tf.appendText("copyPixels with another alpha\ntime = " + time / 100 + "ms\n\n");
            
            bd1.dispose();
            bd2.dispose();
            bd3.dispose();
        }

        private function getVectorTest():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x80FF0000);
            var bd2:Vector.<uint>;
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 10; i++) {
                bd2 = bd1.getVector(bd1.rect);
            }
            
            var time:int = getTimer() - start;
            tf.appendText("getVector\ntime = " + time / 10 + "ms\n\n");
            
            bd1.dispose();
        }

        private function getPixelsTest():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x80FF0000);
            var bd2:ByteArray;
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 100; i++) {
                bd2 = bd1.getPixels(bd1.rect);
            }
            
            var time:int = getTimer() - start;
            tf.appendText("getPixels\ntime = " + time / 100 + "ms\n\n");
            
            bd1.dispose();
        }

        private function getPixelTest():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x80FF0000);
            var pixel:uint;
            var i:int;
            var x:int;
            var y:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 10; i++) {
                for (y = 0; y < 600; y++) {
                    for (x = 0; x < 800; x++) {
                        pixel = bd1.getPixel(x, y);
                    }
                }
            }
            
            var time:int = getTimer() - start;
            tf.appendText("getPixel\ntime = " + time / 10 + "ms\n\n");
            
            bd1.dispose();
        }

        private function getPixel32Test():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x80FF0000);
            var pixel:uint;
            var i:int;
            var x:int;
            var y:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 10; i++) {
                for (y = 0; y < 600; y++) {
                    for (x = 0; x < 800; x++) {
                        pixel = bd1.getPixel32(x, y);
                    }
                }
            }
            
            var time:int = getTimer() - start;
            tf.appendText("getPixel32\ntime = " + time / 10 + "ms\n\n");
            
            bd1.dispose();
        }

        private function copyPixelsWithRepeatTest():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x80FF0000);
            var bd2:BitmapData = new BitmapData(800, 600, true, 0x8000FF00);
            var i:int, x:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 100; i++) {
                var rect:Rectangle = new Rectangle(0, 0, 20, 600);
                var p:Point = new Point();
                for (x = 0; x < 800; x += 20) {
                    bd2.copyPixels(bd1, rect, p, null, null, true);
                    rect.x += 20;
                    p.x += 20;    
                }
            }
            
            var time:int = getTimer() - start;
            tf.appendText("copyPixels with repeat\ntime = " + time / 100 + "ms\n\n");
            
            bd1.dispose();
            bd2.dispose();
        }

        private function graphicsBitmapFillWithRepeatTest():void {
            var bd1:BitmapData = new BitmapData(20, 600, true, 0x80FF0000);
            var bd2:BitmapData = new BitmapData(800, 600, true, 0x8000FF00);
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 100; i++) {
                var shape:Shape = new Shape;
                var g:Graphics = shape.graphics;
                g.beginBitmapFill(bd1);
                g.drawRect(0, 0, 800, 600);
                g.endFill();
                bd2.draw(shape);
            }
            
            var time:int = getTimer() - start;
            tf.appendText("Graphics bitmapFill with repeat\ntime = " + time / 100 + "ms\n\n");
            
            bd1.dispose();
            bd2.dispose();
        }

        private function copyChannelTest():void {
            var bd2:BitmapData = new BitmapData(800, 600, true, 0x8000FF00);
            var bd3:BitmapData = new BitmapData(800, 600, true, 0x800000FF);
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 20; i++) {
                bd3.copyChannel(bd2, bd2.rect, new Point, BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
            }
            
            var time:int = getTimer() - start;
            tf.appendText("copyChannel\ntime = " + time / 20 + "ms\n\n");
            
            bd2.dispose();
            bd3.dispose();
        }

        private function colorMatrixFilterTest():void {
            var bd1:BitmapData = new BitmapData(800, 600, true, 0x8080FF40);
            var bd2:BitmapData = new BitmapData(800, 600, true, 0x8080FF40);
            var cmf:ColorMatrixFilter = new ColorMatrixFilter([
                    0,0,1,0,0,
                    0,1,0,0,0,
                    1,0,0,0,0,
                    0,0,0,1,0]);
            var i:int;
            
            var start:int = getTimer();
      
            for (i = 0; i < 100; i++) {
                bd2.applyFilter(bd1, bd1.rect, new Point, cmf);
            }
            
            var time:int = getTimer() - start;
            tf.appendText("ColorMatrixFilter\ntime = " + time / 100 + "ms\n\n");
            
            bd1.dispose();
        }
     }
}
