/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4jjs
 */

package {
	import flash.display.Sprite;
	import flash.utils.escapeMultiByte;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	[SWF(width = "240",height = "180")]
	public class StringTotalBytes extends Sprite {
		private const COUNT:int = 100000;  // 0;
		private var started:uint;
		private var my_txt:TextField = new TextField();
		private var label_txt:TextField = new TextField();
		public function StringTotalBytes() {
			var test_str:String = "くぁwせdrftgyふじこlp";
			// Creating a TextField for display
			createTextField();
			// Starting test
			use_escapeMultiByte(test_str);
			use_ByteArray(test_str);
			use_code(test_str);
		}
        private function use_escapeMultiByte(test_str:String):void {
            started = getTimer();
            for (var i:int = 0; i < COUNT; i++) {
                var n:uint = getBytesTotal_escapeMultiByte(test_str);
				// trace(n);
            }
            xTrace(getTimer() - started);
        }
        private function use_ByteArray(test_str:String):void {
            started = getTimer();
            for (var i:int = 0; i < COUNT; i++) {
                var n:uint = getBytesTotal_ByteArray(test_str);
				// trace(n);
            }
            xTrace(getTimer() - started);
        }
        private function use_code(test_str:String):void {
            started = getTimer();
            for (var i:int = 0; i < COUNT; i++) {
                var n:uint = getBytesTotal_code(test_str);
				// trace(n);
            }
            xTrace(getTimer() - started);
        }
		private function getBytesTotal_escapeMultiByte(_str:String):uint {
			var nCount:uint = 0;
			var nLength:int = _str.length;
			for (var i:uint = 0; i < nLength; i++) {
				nCount += (escapeMultiByte(_str.charAt(i)).length > 3) ? 2 : 1;
			}
			return nCount;
		}
		private function getBytesTotal_ByteArray(_str:String):uint {
			var byteArray:ByteArray = new ByteArray();
			byteArray.writeMultiByte(_str, "shift-jis");
			return byteArray.length;
		}
		private function getBytesTotal_code(_str:String):uint {
			var nCount:uint = 0;
			var nLength:int = _str.length;
			for (var i:uint = 0; i < nLength; i++) {
				var char_str:String = _str.charAt(i);
				var nCode:Number = char_str.charCodeAt(0);
				var bSingle:Boolean = (nCode < 0x7F) || (0xFF61 < nCode && nCode < 0xFF9F);
				nCount +=  bSingle ? 1:2;
			}
			return nCount;
		}
		private function createTextField():void {
			addChild(my_txt);
			addChild(label_txt);
			my_txt.x +=  20;
			my_txt.autoSize = TextFieldAutoSize.RIGHT;
			label_txt.autoSize = TextFieldAutoSize.LEFT;
			label_txt.text = "escapeMultiByte():\nByteArray:\ncharacter code:";
		}
		private function xTrace(n:int):void {
			my_txt.appendText(String(n) + "\n");
		}
	}
}