/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4jaB
 */

package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     * @author kiyo
     */
    public class Random extends Sprite
    {
        private var speed:Array;
        private var angle:Array;
        private var balls:Array;
        private var numBall:uint = 10;
        private var xRange:Number = 10, yRange:Number = 6;
        
        public function Random() 
        {
            balls = [];
            speed = [];
            angle = [];
            for (var i:int = 0; i < numBall; i++) 
            {
                var ball:Ball = new Ball(Math.random() * 30 + 10, Math.random() * 0xffffff);
                ball.x = stage.stageWidth * Math.random();
                ball.y = stage.stageHeight * Math.random();
                addChild(ball);
                balls.push(ball);
                speed.push(new Array(Math.random() * ball.radius/100 + 0.4, Math.random() * ball.radius/100 + 0.3));//それぞれ振動の周期を変える。半径が大きいほど周期が短い
                angle.push(new Array(0, 0));
            }
            addEventListener(Event.ENTER_FRAME, enterframeHandler);
        }
        
        private function enterframeHandler(e:Event):void 
        {
            for (var i:int = 0; i < numBall; i++) 
            {
                var ball:Ball = balls[i];
                ball.vx = Math.sin(angle[i][0]) * xRange;
                ball.vy = Math.sin(angle[i][1]) * yRange;
                ball.x += ball.vx;
                ball.y += ball.vy;
                angle[i][0] += speed[i][0];
                angle[i][1] += speed[i][1];
            }
        }
        
        
        
    }

}

import flash.display.Sprite;

class Ball extends Sprite {
    public var vx:Number;
    public var vy:Number;
    private var _radius:Number;
    private var _color:Number;

    public function Ball(radius:Number=10,color:uint=0xff0000) {
        _radius=radius;
        _color=color;
        update();
    }

    private function update():void {
        graphics.clear();
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill();
    }

    public function setRadius(radius:Number):void {
        _radius=radius;
        update();
    }

    public function setColor(color:uint):void {
        _color=color;
        update();
    }

    public function get radius():Number {
        return _radius;
    }

    public function get color():Number {
        return _color;
    }
}