/**
 * Copyright javotetsu ( http://wonderfl.net/user/javotetsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4jHe
 */

/*
*テキストフィールドに入力された文字列を、右から左へとランダムな縦位置で
*流します。
*ボタンが押下されてもテキストフィールドをクリアしないので、
*　ｗｗｗとか８８８８８とか入力してボタン連打すると弾幕っぽいものが
* 自演できる。。。
*/
package  
{
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    
    import com.bit101.components.*;
    
    [SWF(backgroundColor=0xFFFFFF )]
    public class CommentStream extends Sprite
    {
        //Documentクラスのインスタンス宣言
        public static var _Instance:CommentStream = null;
      
        //コメント入力欄
        private var CommentInput:TextField;
          
        //MimalComps
        //private var comment:InputText;
        private var CommentColor:ColorChooser;
        private var SendButton:PushButton;
        private var LabelComment:Label;
        private var LabelColor:Label;
        
        //
        public var STAGE_WIDTH:Number;
        public var STAGE_HEIGHT:Number;
        
        private var CommentArray:Array;
        
        public function CommentStream() 
        {
            _Instance = this;
            
            STAGE_WIDTH = this.stage.stageWidth;
            STAGE_HEIGHT = this.stage.stageHeight;
            
            CommentArray = new Array();

            //コメント入力フィールド
            CommentInput = new TextField();
            CommentInput.type = TextFieldType.INPUT;
            CommentInput.backgroundColor = 0xFFFFFF;
            CommentInput.border = true;
            CommentInput.borderColor = 0x000000;
            CommentInput.width = 250;
            CommentInput.height = 25;
            CommentInput.x = STAGE_WIDTH*0.05;
            CommentInput.y = STAGE_HEIGHT*0.90;
            addChild( CommentInput);
            //コメントの色指定用のカラーピッカー(minimalcomps)
            CommentColor = new ColorChooser(this, CommentInput.x+CommentInput.width+10, STAGE_HEIGHT*0.90, 0x000000 , CommentColorHandler );
            CommentColor.usePopup = true;
            CommentColor.popupAlign = ColorChooser.TOP;
            //送信ボタン(minimalcomps)
            SendButton = new PushButton(this, CommentInput.x+CommentInput.width+10+CommentColor.width+10 , STAGE_HEIGHT*0.90, "put" , SendButtonHandler );
                
        }
        
        //カラーピッカーで色が選択されたとき
        private function CommentColorHandler(e:Event):void {
        }
        //送信ボタンが押下されたとき
        private function SendButtonHandler(e:Event):void {
            var COMMENT_COLOR:String;
            if ( CommentInput.text ) {
                //Commentクラスをインスタンス化する
                CommentArray.push(new Comment( CommentInput.text , CommentColor.value.toString(16) , 1 , 1) );
            }
        }
        //ドキュメントルートのインスタンスを他のクラスに渡す
        public static function GetInstance():CommentStream {
            return _Instance;
        }
        
    }

}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;

import caurina.transitions.Tweener;

class Comment extends Sprite {
    
    private var _STAGE:CommentStream;
    private var CommentBaseSprite:Sprite;
    private var comment_text:TextField;
    private var comment_text_format:TextFormat;
    private var bitmapcommentdata:BitmapData;
    private var bitmapcomment:Bitmap;
    
    //引数は_COMMENTと_COLORしか処理してません。それ以降の引数は文字の大きさとか、コメントを流すスピードとかを渡して反映させられれば、と思いつつ実装してません。。。
    public function Comment( _COMMENT:String , _COLOR:String , _SIZE:Number , _SPEED:Number ):void {
        
        _STAGE = CommentStream.GetInstance();//ドキュメントクラス（ステージ）のインスタンスを取得
        comment_text_format = new TextFormat();
        comment_text_format.size = 25;
        comment_text = new TextField();
        comment_text.autoSize = TextFieldAutoSize.LEFT;
        comment_text.antiAliasType = AntiAliasType.ADVANCED;
        comment_text.defaultTextFormat = comment_text_format;
        comment_text.textColor = uint( "0x" + _COLOR );
        comment_text.text = _COMMENT;
        //テキストフィールドをビットマップ化する
        bitmapcommentdata = new BitmapData( _STAGE.STAGE_WIDTH , 40 , true, 0x00ffffff);
        bitmapcommentdata.draw( comment_text );
        bitmapcomment = new Bitmap( bitmapcommentdata );
        
        bitmapcomment.x = _STAGE.STAGE_WIDTH + 10;
        bitmapcomment.y = Math.floor(Math.random() * _STAGE.STAGE_HEIGHT );
        _STAGE.addChild( bitmapcomment );
        
        //ビットマップ化したコメントを流す(tweener)
        Tweener.addTween( bitmapcomment , { x: -(_STAGE.STAGE_WIDTH + 10) , time:7 , transition:"linear" , onComplete:RemoveComment } );
    }
    
    //ステージの外に出たらビットマップデータを消去
    private function RemoveComment():void {
        _STAGE.removeChild( bitmapcomment );
        bitmapcommentdata.dispose();
    }
    
}