/**
 * Copyright Diablo404 ( http://wonderfl.net/user/Diablo404 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4jD8
 */

// forked from only3km's Fan
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.text.TextField;
    
    [SWF(width='600',height='600',frameRate='64',backgroundColor='#000000')]
    
    public class Fan extends Sprite
    {
        private var child:Sprite = new Sprite();
        private var children:Array = [ ];
        private var rpf:Number = 1;
        
        public function Fan()
        {
            var s:Sprite;
            var i:int = 6;
            var r:int = 40;
            while(i--)
            {
                s = getElement();
                s.rotationZ = i * 60;
                s.rotationX = 30;
                s.x = Math.cos(s.rotationZ/180*Math.PI) * r;
                s.y = Math.sin(s.rotationZ/180*Math.PI) * r;
                child.addChild(s);
            }
            
            this.x = 300;
            this.y = 300;
            this.z = 300;
            addChild(child);
            
            children.length = 0;
            i = this.numChildren;
            while(i--)
                children.unshift(new Child(this.getChildAt(i)));
            
            stage.scaleMode = 'noScale';
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        // colors from
        // http://www.colourlovers.com/print/trends/magazines/7870/eye_-_78
        private var colors:Array = [ 0xc8ebfe, 0xd1c756, 0xfca44b, 0xffd843, 0xe0d1cc, 0xcde8d5 ];
        private var colorIndex:int = 0;
        
        private function getElement():Sprite
        {
            var s:Sprite = new Sprite();
            s.graphics.beginFill(colors[colorIndex++], .7);
            s.graphics.moveTo(0,-20);
            s.graphics.lineTo(160,-40);
            s.graphics.curveTo(200,-40,200,0);
            s.graphics.curveTo(200,40,160,40);
            s.graphics.lineTo(0,20);
            s.graphics.lineTo(0,-20);
            s.graphics.endFill();
            s.cacheAsBitmap = true;
            return s;
        }
        
        private function onEnterFrame(event:Event):void
        {
            child.rotationZ += rpf;
            children.sortOn('distance', Array.NUMERIC);
            for each (var c:Child in children)
            this.setChildIndex(c.displayObject, 0);
        }
        
        private var blur:int = -1;
        
        private function onMouseMove(event:MouseEvent):void
        {
            this.rotationX = event.stageY - this.y;
            rpf = (event.stageX - this.x) * .03;
            var i:int = int(Math.abs(rpf*2));
            if(blur!=i)
            {
                blur = i;
                var a:Array = [ new BlurFilter(0,blur,3) ];
                var n:int = child.numChildren;
                while(n--) child.getChildAt(n).filters = a;
            }
            //this.rotationY = event.stageX - 300;
        }
    }
}

import flash.display.DisplayObject;
import flash.geom.PerspectiveProjection;
import flash.geom.Vector3D;

class Child
{
    public var displayObject:DisplayObject;
    
    public function Child(displayObject:DisplayObject) { this.displayObject = displayObject; }
    
    public function get z():Number { return displayObject.transform.getRelativeMatrix3D(displayObject.stage).position.z; }
    
    public function get distance():Number
    {
        var p:Vector3D = displayObject.transform.getRelativeMatrix3D(displayObject.stage).position;
        var pp:PerspectiveProjection = displayObject.stage.transform.perspectiveProjection;
        return Math.sqrt( Math.pow(p.x-pp.projectionCenter.x, 2)+
            Math.pow(p.y-pp.projectionCenter.y, 2)+
            Math.pow(p.z+pp.focalLength, 2) );
    }
}