/**
 * Copyright moriyak ( http://wonderfl.net/user/moriyak )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4izt
 */

package 
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	
	/**
	 * ひも
	 */
	public class Main extends Sprite 
	{
		protected var _pointArray:/*Point*/Array;
		protected var _speedArray:/*point*/Array;
		protected var _segmentNum:int = 150;
		protected var _segmentLength:int = 6;
		protected var _friction:Number = 0.8;
		protected var _gravity:Number = 3;
		protected var _marker:Sprite;
		protected var _lineColor:uint;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			_createMarker();
			_initArrays();
			this.addEventListener(Event.ENTER_FRAME, _onEnterFrame);
		}
		
		protected function _createMarker():void
		{
			_marker = new Sprite();
			var g:Graphics = _marker.graphics;
			g.beginFill(0xFF1493);
			g.drawRect( -10, -10, 20, 20);
			g.endFill();
			this.addChild(_marker);
		}
		
		protected function _initArrays():void
		{
			_speedArray = new Array(_segmentNum);
			_pointArray = new Array(_segmentNum);
			for (var i:int = 0; i < _segmentNum; i++) {
				_pointArray[i] = new Point(0, i);
				_speedArray[i] = new Point(0, 0);
			}
		}
		
		protected function _onEnterFrame(e:Event):void
		{
			_updatePointArray();
			_updateMarker();
			_drawLines();
		}
		
		protected function _updatePointArray():void
		{
			_pointArray[0].x = this.mouseX;
			_pointArray[0].y = this.mouseY;
			for (var i:int = 1; i < _segmentNum; i++) {
				_updatePoint(_pointArray[i], _pointArray[i - 1], _speedArray[i]);
			}
		}
		
		protected var _normalizer:Point, _normalizedPoint:Point;
		protected function _updatePoint(current:Point, prev:Point, speed:Point):void
		{
			speed.x += (prev.x - current.x) / 10;
			speed.y += (prev.y - current.y) / 10 + _gravity;
			speed.x *= _friction;
			speed.y *= _friction;
			
			current.x += speed.x;
			current.y += speed.y;
			_normalizer = current.subtract(prev);
			_normalizer.normalize(_segmentLength);
			_normalizedPoint = prev.add(_normalizer);
			current.x = _normalizedPoint.x;
			current.y = _normalizedPoint.y;
		}
		
		protected function _updateMarker():void
		{
			_marker.rotation = _getRotationDegree();
			_marker.x = _pointArray[_pointArray.length - 1].x;
			_marker.y = _pointArray[_pointArray.length - 1].y;
			
			_lineColor = (_marker.y < this.stage.stageHeight) ? 0xFF0000 : 0;
		}
		
		protected function _getRotationDegree():int
		{
			// http://archive.mag2.com/0000118977/20061217103457000.html
			var p:Point = _pointArray[_pointArray.length - 1].subtract(_pointArray[_pointArray.length - 2]);
			var lad:Number = Math.atan2(p.y, p.x);
			return (lad * (180 / Math.PI));
		}
		
		protected function _drawLines():void
		{
			var g:Graphics = this.graphics;
			g.clear();
			g.lineStyle(0, _lineColor);
			g.moveTo(this.mouseX, this.mouseY);
			for (var i:int = 1; i < _segmentNum; i++) {
				g.lineTo(_pointArray[i].x, _pointArray[i].y);
			}
		}
	}
}