/**
 * Copyright paulstamp1 ( http://wonderfl.net/user/paulstamp1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4ijO
 */

// forked from paulstamp1's Orbit
/**                                                          
     _____ _____ _____ __       _____ _____ _____ _____ _____ 
    |  _  |  _  |  |  |  |     |   __|_   _|  _  |     |  _  |
    |   __|     |  |  |  |__   |__   | | | |     | | | |   __|
    |__|  |__|__|_____|_____|  |_____| |_| |__|__|_|_|_|__|   
    @paulstamp
                                                       
    This example shows basic planetary
    orbit with decent 

*/
package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var _planetA:Planet;
        private var _planetB:Planet;
        private var _clockwise:Boolean;
        private var _maxOrbitHeight:Number = 160;
        private var _minOrbitHeight:Number = 30;
        private var _orbitDecent:Number = 0.05;
        private var _orbitHeight:Number = _maxOrbitHeight;
        private var _orbitalAlpha:Number = 0;
        private var _orbitalAlphaIncrement:Number = 0.001;
        private var _speed:Number = 2;
        
        public function FlashTest() {
            // write as3 code here..
            
            _planetA = new Planet( 20 );
            _planetA.x = 465>>1;
            _planetA.y = 465>>1;
            addChild( _planetA );
            
            _planetB = new Planet( 10 );
            addChild( _planetB );
            
            addEventListener( Event.ENTER_FRAME, update );
        }
        
        private function nextPoint():Point
        {
            var rad:Number = _planetB.rotation * Math.PI / 180;//degrees to rads
            var radius:Number = 30 + _orbitHeight;
            var difX:Number = _planetA.x - _planetB.x;
            var difY:Number = _planetA.y - _planetB.y;

            var velocityX:Number = difX + radius * Math.cos(rad);
            var velocityY:Number = difY + radius * Math.sin(rad);
                
            return new Point( _planetB.x + velocityX, _planetB.y + velocityY );
        }

        private function update( event:Event ):void
        {
            var next:Point = nextPoint();
            _planetB.x = next.x;
            _planetB.y = next.y;
           
            if( _clockwise )
            {
                _planetB.rotation += _speed;
            }
            else
            {
                _planetB.rotation -= _speed;
            }
          
            var nextStep:Point = nextPoint();
            this.graphics.lineStyle( 2, 0x009900, _orbitalAlpha );
            this.graphics.lineTo( nextStep.x, nextStep.y );
            _orbitalAlpha += _orbitalAlphaIncrement;
            
            if( _orbitHeight > _minOrbitHeight )
            {
                _orbitHeight -= _orbitDecent;
            }

           
        }

    }
}
import flash.display.Sprite;

class Planet extends Sprite
{
    public var radius:Number;
    
    public function Planet( radius:Number )
    {
        this.radius = radius;
        this.graphics.beginFill( 0x009900 );
        this.graphics.drawCircle( 0,0, radius );
        this.graphics.endFill();
    }

}
