/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4iLu
 */

// forked from FLASHMAFIA's BITFIRE | 10
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.IBitmapDrawable;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;

    [SWF(width = "465", height = "465")]
    public class BitFire extends Sprite {
        private const NUM_P : int = 1 << 17;
        /* */
        private var ppp : Vector.<Particle>;
        private var bmd : BitmapData;
        private var srcBmd : BitmapData;
        private var src : Sprite;
        private var tf : TextField;
        private var buf : Vector.<uint>;
        private var ct : ColorTransform;
        private var blur : BlurFilter;
        private var t : int;
        private var pcnt : int;
        private var ccnt : int;

        function BitFire() {
            stage.stageFocusRect = mouseEnabled = tabEnabled = tabChildren = false;
            stage.scaleMode = "noScale";
            stage.align = "TL";
            stage.quality = "low";
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            bmd = new BitmapData(512, 512, false, 0x0);
            srcBmd = new BitmapData(512, 512, false, 0x0);
            buf = new Vector.<uint>(512 * 512, true);

            var bm : Bitmap = new Bitmap(bmd);
            bm.x = bm.y = (465 - 512) >> 1;
            bm.opaqueBackground = 0x0;
            addChild(bm);

            /* p */

            ppp = new Vector.<Particle>(NUM_P, true);

            var n : uint = NUM_P;
            while (n-- != 0) {
                var p : Particle = new Particle();

                var f : Number = n / NUM_P;
                var a : Number = (2 * 6.283185307179586) * f;
                var nn : int = (n & 255);

                p.x = p.tx = p.ex = 256 + (512 - 128 + nn) * Math.cos(a);
                p.y = p.ty = p.ey = 256 + (512 - 128 + nn) * Math.sin(a);

                p.tt = (n & 127) >> 1;

                p.t = -p.tt;
                p.td = 1;

                ppp[n] = p;
            }

            tf = new TextField();
            tf.defaultTextFormat = new TextFormat("_sans", 222, 0xFFFFFF, true);
            tf.autoSize = TextFieldAutoSize.LEFT;

            src = new Sprite();
            src.addChild(tf);

            ct = new ColorTransform(0.975, 0.95, 0.915);
            blur = new BlurFilter(4.0, 4.0, 1);

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void {
            t++;

            if ((t & 127) == 1) {
                ccnt++;

                tf.text = (((ccnt & 31) < 10) ? "0" : "") + String(ccnt & 31);
                tf.x = (512 - tf.width) / 2;
                tf.y = (512 - tf.height) / 2;
                tf.textColor = 0xFF4000;
                tf.filters = [new GlowFilter(tf.textColor, 1.0, 8.0, 8.0, 2, 1)];

                atomize(src);
            }

            bmd.lock();
            bmd.colorTransform(bmd.rect, ct);
            bmd.applyFilter(bmd, bmd.rect, bmd.rect.topLeft, blur);

            buf = bmd.getVector(bmd.rect);

            var n : uint = NUM_P - (t & 1);
            while (n > 2) {
                n--;
                n--;

                var p : Particle = ppp[n];

                var dx : Number = p.ex - 256;
                var dy : Number = p.ey - 256;

                p.ex = 256 + ((0.9998476951563913) * dx - (0.01745240643728351) * dy);
                p.ey = 256 + ((0.9998476951563913) * dy + (0.01745240643728351) * dx);

                var c0 : uint = bmd.getPixel(p.x >> 0, p.y >> 0);

                var r : uint = (c0 >> 16);
                var g : uint = (c0 >> 8 & 0xFF);
                var b : uint = (c0 & 0xFF);

                p.t += p.td;

                if (p.t < 0) {
                    p.x += (p.tx - p.x) * 0.15;
                    p.y += (p.ty - p.y) * 0.15;
                } else {
                    p.x += (p.ex - p.x) * 0.0077;
                    p.y += (p.ey - p.y) * 0.0077;
                }

                r += 0x28;
                g += 0x26;
                b += 0x24;

                if (r > 0xFF) r = 0xFF;
                if (g > 0xF8) g = 0xF8;
                if (b > 0xF0) b = 0xF0;

                buf[(p.x & 511) + ((p.y & 511) << 9)] = (r << 16 | g << 8 | b);
            }

            bmd.setVector(bmd.rect, buf);
            bmd.unlock();
        }

        private function atomize(src : IBitmapDrawable) : void {
            srcBmd.fillRect(srcBmd.rect, 0x0);
            srcBmd.draw(src);

            var p : Particle;

            var n : uint = NUM_P;
            while (--n != 0) {
                p = ppp[n];

                if (p.td < 0) {
                    p.t = -p.tt;
                    p.td = 1;
                }
            }

            var pos : int = (512 * 512) - (512 << 7) - (ccnt & 1);
            while (pos > (512 << 7)) {
                pos--;
                pos--;

                var tx : int = pos & 511;
                var ty : int = pos >> 9;

                var tc : uint = srcBmd.getPixel(tx, ty);
                if (tc == 0x0) continue;

                pcnt++;

                p = ppp[pcnt & (NUM_P - 1)];

                if (p.td > 0) {
                    p.td = -1;
                }

                p.tx = tx;
                p.ty = ty;
            }
        }
    }
}

internal class Particle {
    public var t : int;
    public var tt : int;
    public var td : int;
    public var x : Number;
    public var y : Number;
    public var tx : int;
    public var ty : int;
    public var ex : Number;
    public var ey : Number;
}