/**
 * Copyright matsumos ( http://wonderfl.net/user/matsumos )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4hvM
 */

/**
 * 下のほうにあるグレーのボタンをクリックすると、アルファベットの書かれたカードが順番に出てきます。
 * Aのカードはremoveしちゃうんで、BからHまでのカードが出てきますよ。
 * いまいちよくわかっていないので、誰かツッコミを入れてくれることを期待します。
 */
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	public class Main extends Sprite 
	{
		private var _iterator:IPreviousableIterator;
		private var _nextButton:Button;
		private var _previousButton:Button;
		private var _collection:Collection;
		
		public function Main()
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			_collection = new Collection();
			_collection.add(new Card("A", 0x111111));
			_collection.add(new Card("B", 0x222222));
			_collection.add(new Card("C", 0x333333));
			_collection.add(new Card("D", 0x444444));
			_collection.add(new Card("E", 0x555555));
			_collection.add(new Card("F", 0x666666));
			_collection.add(new Card("G", 0x777777));
			_collection.add(new Card("H", 0x888888));
			
			_iterator = _collection.iterator;
			
			_nextButton = new Button();
			_nextButton.x = 50;
			_nextButton.y = 200;
			addChild(_nextButton);
			
			_previousButton = new Button();
			_previousButton.x = 150;
			_previousButton.y = 200;
			addChild(_previousButton);
			
			_nextButton.addEventListener(MouseEvent.CLICK, nextButtonClick);
			_previousButton.addEventListener(MouseEvent.CLICK, previousButtonClick);
			_iterator.addEventListener(Event.CHANGE, iteratorChange);

			_iterator.remove(); // remove A
			addChild( _iterator.next );
		}
		
		private function nextButtonClick(e:MouseEvent):void
		{
			if (_iterator.hasNext) addChild( _iterator.next );
		}
		
		private function previousButtonClick(e:MouseEvent):void
		{
			if (_iterator.hasPrevious) addChild( _iterator.previous );
		}
		
		private function iteratorChange(e:Event):void
		{
			if (_iterator.hasNext) _nextButton.label = _iterator.nextIndex.toString();
			if (_iterator.hasPrevious) _previousButton.label = _iterator.previousIndex.toString();
			_nextButton.visible = _iterator.hasNext;
			_previousButton.visible = _iterator.hasPrevious;
		}
	}
}


//

import flash.display.Sprite;
import flash.events.EventDispatcher;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;

class Card extends Sprite
{
	public function Card(str:String, color:int)
	{
		name = str;
		
		graphics.beginFill(color);
		graphics.drawRect(0, 0, 100, 100);
		graphics.endFill();
		
		var tf:TextField = new TextField();
		tf.text = str;
		tf.x = tf.y = 40;
		tf.height = 20;
		tf.width = 20;
		tf.background = true;
		tf.autoSize = TextFieldAutoSize.CENTER;
		tf.backgroundColor = 0xFFFFFF;
		addChild(tf);
	}
}


//

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;

class Button extends Sprite
{
	private var _label:TextField;
	public function set label(value:String):void { _label.text = value };
		
	public function Button()
	{
		graphics.beginFill(0xCCCCCC);
		graphics.drawRect(0, 0, 50, 20);
		graphics.endFill();
		
		_label = new TextField();
		_label.autoSize = TextFieldAutoSize.LEFT;
		addChild(_label);
	}
}


//

class Collection implements IIterableAggregate
{
	private var _data:Array = [];
	
	public function add(value:*):void
	{
		_data.push(value);
	}
	
	public function get iterator():IPreviousableIterator
	{
		return new Iterator(_data);
	}
}


//

interface IIterableAggregate
{	
	function get iterator():IPreviousableIterator;
}


//

import flash.events.Event;

class Iterator extends EventDispatcher implements IPreviousableIterator
{
	private var _index:int = 0;
	private var _lastRet:int = -1;
	private var _collection:Array;
	
	public function Iterator(collection:Array)
	{
		_collection = collection;
	}
	
	public function get hasNext():Boolean
	{
		return _index != _collection.length && _collection.length > 0;
	}
	
	public function get next():*
	{	
		var next:* = _collection[nextIndex];
		_lastRet = _index++;
		dispatchEvent(new Event(Event.CHANGE));
		return next;
	}
	
	public function get currentIndex():int
	{	
		return _index -1;
	}
	
	public function get current():*
	{	
		return _collection[_index];
	}
	
	public function get nextIndex():int {
		return _index;
	}
	
	public function get previousIndex():int {
		return _index - 2;
	}
	
	public function get hasPrevious():Boolean
	{
		return _index != 1 && _collection.length > 0;
	}
	
	public function get previous():*
	{
		var prev:* = _collection[previousIndex];
		_lastRet = _index = _index - 1;
		dispatchEvent(new Event(Event.CHANGE));
		return prev;
	}
		
	public function reset():void
	{
		_index = 0;
		_lastRet = -1;
	}
	
	public function remove():void
	{
		_collection.splice(_index,1);
	}
}


//

interface IPreviousableIterator extends IIterator
{
	function get previous():*;
	function get hasPrevious():Boolean;
	function get nextIndex():int;
	function get previousIndex():int;
	function get currentIndex():int;
	function get current():*;
	function remove():void;
}


//

import flash.events.IEventDispatcher;

interface IIterator extends IEventDispatcher
{
	function reset():void;
	function get next():*;
	function get hasNext():Boolean;
}